/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.util;

import android.os.SystemClock;
import com.helpshift.model.InfoModelFactory;
import com.helpshift.util.HSFormat;
import java.util.Date;

public class TimeUtil {
    private static final String TAG = "HelpshiftDebug";
    public static long EARLIEST_ALLOWED_UNIX_TIME = 0L;

    public static Float calculateTimeAdjustment(String serverTime) {
        String deviceTime = HSFormat.tsSecFormatter.format((double)System.currentTimeMillis() / 1000.0);
        Double timeStamp = Double.parseDouble(serverTime) * 1000.0;
        Date serverDate = new Date((long)timeStamp.doubleValue());
        Float timeDelta = Float.valueOf((float)((double)(serverDate.getTime() / 1000L) - Double.parseDouble(deviceTime)));
        return timeDelta;
    }

    @Deprecated
    public static String getAdjustedTimestamp(Float timeDelta) {
        String deviceTs = HSFormat.tsSecFormatter.format((double)System.currentTimeMillis() / 1000.0);
        if (timeDelta != null && timeDelta.floatValue() != 0.0f) {
            Double deviceTsFloat = (double)System.currentTimeMillis() / 1000.0;
            deviceTs = HSFormat.tsSecFormatter.format(deviceTsFloat + (double)timeDelta.floatValue());
        }
        return deviceTs;
    }

    public static long getAdjustedTimeInMillis(Float timeDelta) {
        long deviceTs = System.currentTimeMillis();
        if (timeDelta != null && timeDelta.floatValue() != 0.0f) {
            deviceTs = (long)((float)deviceTs + timeDelta.floatValue() * 1000.0f);
        }
        return deviceTs;
    }

    public static long getCurrentTimeInMillis() {
        return TimeUtil.getAdjustedTimeInMillis(InfoModelFactory.getInstance().sdkInfoModel.getServerTimeDelta());
    }

    public static String getCurrentTimestamp() {
        return TimeUtil.getAdjustedTimestamp(InfoModelFactory.getInstance().sdkInfoModel.getServerTimeDelta());
    }

    public long elapsedTimeMillis() {
        return SystemClock.elapsedRealtime();
    }
}

