/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.util.concurrent;

import android.util.Log;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;

public class DispatchQueue {
    private static final String TAG = "HelpshiftDebug";
    private LinkedBlockingQueue<Future> tasks = new LinkedBlockingQueue();
    private LinkedBlockingQueue<Thread> afterThreads = new LinkedBlockingQueue();
    private ExecutorService threadPoolExecutor;

    public DispatchQueue(boolean isConcurrent) {
        this.threadPoolExecutor = isConcurrent ? Executors.newCachedThreadPool() : Executors.newSingleThreadExecutor();
    }

    public void dispatchSync(Runnable runnable) {
        Future<?> taskFuture = this.threadPoolExecutor.submit(runnable);
        try {
            taskFuture.get();
        }
        catch (InterruptedException e) {
            Log.d((String)TAG, (String)"Runnable interrupted : ", (Throwable)e);
        }
        catch (ExecutionException e) {
            Log.d((String)TAG, (String)"Execution exception : ", (Throwable)e);
        }
    }

    private void trackTask(Future task) {
        this.tasks.add(task);
    }

    public void dispatchAsync(Runnable runnable) {
        Future<?> task = this.threadPoolExecutor.submit(runnable);
        this.trackTask(task);
    }

    public void dispatchAfter(final Runnable runnable, final long interval) {
        final DispatchQueue queue = this;
        Thread triggerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(interval);
                    queue.dispatchAsync(runnable);
                }
                catch (InterruptedException e) {
                    Log.d((String)DispatchQueue.TAG, (String)"Runnable interrupted : ", (Throwable)e);
                }
            }
        });
        triggerThread.start();
        this.afterThreads.add(triggerThread);
    }

    public void join() {
        try {
            for (Thread t : this.afterThreads) {
                t.join();
            }
            for (Future task : this.tasks) {
                task.get();
            }
            this.tasks.clear();
        }
        catch (InterruptedException e) {
            Log.d((String)TAG, (String)"Runnable interrupted : ", (Throwable)e);
        }
        catch (ExecutionException e) {
            Log.d((String)TAG, (String)"Execution exception : ", (Throwable)e);
        }
    }
}

