/*
 * Decompiled with CFR 0.152.
 */
package com.here.account.auth;

import com.here.account.auth.SignatureCalculator;
import com.here.account.auth.SignatureMethod;
import com.here.account.http.HttpProvider;
import com.here.account.util.Clock;
import com.here.account.util.SettableSystemClock;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;

public class OAuth1Signer
implements HttpProvider.HttpRequestAuthorizer {
    private static final int NONCE_LENGTH = 6;
    private final Clock clock;
    private final String consumerKey;
    private final String consumerSecret;
    private final SignatureMethod signatureMethod;

    public OAuth1Signer(String accessKeyId, String accessKeySecret) {
        this(new SettableSystemClock(), accessKeyId, accessKeySecret);
    }

    public OAuth1Signer(Clock clock, String accessKeyId, String accessKeySecret) {
        this(clock, accessKeyId, accessKeySecret, SignatureMethod.HMACSHA256);
    }

    public OAuth1Signer(String consumerKey, String consumerSecret, SignatureMethod signatureMethod) {
        this(new SettableSystemClock(), consumerKey, consumerSecret, signatureMethod);
    }

    public OAuth1Signer(Clock clock, String consumerKey, String consumerSecret, SignatureMethod signatureMethod) {
        this.clock = clock;
        this.consumerKey = consumerKey;
        this.consumerSecret = consumerSecret;
        this.signatureMethod = signatureMethod;
    }

    protected void nextBytes(byte[] bytes) {
        ThreadLocalRandom.current().nextBytes(bytes);
    }

    private String getAuthorizationHeaderValue(String method, String url, Map<String, List<String>> formParams) {
        SignatureCalculator calculator = this.getSignatureCalculator();
        long timestamp = this.clock.currentTimeMillis() / 1000L;
        byte[] bytes = new byte[6];
        this.nextBytes(bytes);
        String nonce = Base64.getUrlEncoder().withoutPadding().encodeToString(bytes).substring(0, 6);
        String computedSignature = calculator.calculateSignature(method, url, timestamp, nonce, this.signatureMethod, formParams, null);
        return calculator.constructAuthHeader(computedSignature, nonce, timestamp, this.signatureMethod);
    }

    SignatureCalculator getSignatureCalculator() {
        SignatureCalculator calculator = new SignatureCalculator(this.consumerKey, this.consumerSecret);
        return calculator;
    }

    @Override
    public void authorize(HttpProvider.HttpRequest httpRequest, String method, String url, Map<String, List<String>> formParams) {
        String authorizationHeaderValue = this.getAuthorizationHeaderValue(method, url, formParams);
        httpRequest.addAuthorizationHeader(authorizationHeaderValue);
    }
}

