/*
 * Decompiled with CFR 0.152.
 */
package com.here.account.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public class JsonSerializer {
    public static final String CHARSET_STRING = "UTF-8";
    public static final Charset CHARSET = Charset.forName("UTF-8");
    private static ObjectMapper objectMapper = new ObjectMapper();

    public static Map<String, Object> toMap(InputStream jsonInputStream) throws IOException {
        return (HashMap)objectMapper.readValue(jsonInputStream, HashMap.class);
    }

    public static <T> T toPojo(InputStream jsonInputStream, Class<T> pojoClass) throws JsonParseException, JsonMappingException, IOException {
        return (T)objectMapper.readValue(jsonInputStream, pojoClass);
    }

    public static String toJson(Map<String, Object> mapObject) throws JsonProcessingException {
        return objectMapper.writeValueAsString(mapObject);
    }

    public static String objectToJson(Object object) throws JsonProcessingException {
        return objectMapper.writeValueAsString(object);
    }

    static void writeObjectToJson(OutputStream outputStream, Object object) throws JsonGenerationException, JsonMappingException, IOException {
        objectMapper.writeValue(outputStream, object);
    }

    static {
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(MapperFeature.PROPAGATE_TRANSIENT_MARKER, true);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

