/*
 * Decompiled with CFR 0.152.
 */
package com.here.account.auth.provider;

import com.here.account.auth.provider.AbstractClientAuthorizationRequestProvider;
import com.here.account.auth.provider.RequestProviderException;
import com.here.account.http.HttpConstants;
import com.here.account.http.HttpProvider;
import com.here.account.identity.bo.IdentityTokenRequest;
import com.here.account.oauth2.AccessTokenRequest;
import com.here.account.oauth2.ClientAuthorizationRequestProvider;
import com.here.account.util.Clock;
import com.here.account.util.SettableSystemClock;
import java.io.File;
import java.net.URL;
import java.nio.file.Paths;

public class FromRunAsIdFileProvider
extends AbstractClientAuthorizationRequestProvider
implements ClientAuthorizationRequestProvider {
    private static final String FILE_ACCESS_TOKEN_ENDPOINT_URL = "file:///dev/shm/identity/access-token";
    private final String tokenUrl;

    public FromRunAsIdFileProvider() {
        this(new SettableSystemClock());
    }

    public FromRunAsIdFileProvider(Clock clock) {
        this(clock, FILE_ACCESS_TOKEN_ENDPOINT_URL);
    }

    public FromRunAsIdFileProvider(Clock clock, String tokenUrl) {
        super(clock);
        this.tokenUrl = tokenUrl;
    }

    @Override
    public String getTokenEndpointUrl() {
        return this.tokenUrl;
    }

    @Override
    public HttpProvider.HttpRequestAuthorizer getClientAuthorizer() {
        return this.getAuthorizer();
    }

    @Override
    public AccessTokenRequest getNewAccessTokenRequest() {
        return this.getRequest();
    }

    protected void verifyFileIsReadable() {
        File file;
        try {
            URL url = new URL(this.getTokenEndpointUrl());
            file = Paths.get(url.toURI()).toFile();
        }
        catch (Exception e) {
            throw new RequestProviderException("Unable to get HERE Access Token; unable to convert url to file " + this.tokenUrl + ".  If you were trying to use runAsId, contact HERE support.");
        }
        if (!file.exists()) {
            throw new RequestProviderException("Unable to get HERE Access Token.  File " + this.tokenUrl + " does not exist.  If you were trying to use runAsId, contact HERE support.");
        }
        if (!file.canRead()) {
            throw new RequestProviderException("Unable to get HERE Access Token.  File " + this.tokenUrl + " is not readable.  If you were trying to use runAsId, contact HERE support.");
        }
    }

    protected HttpProvider.HttpRequestAuthorizer getAuthorizer() {
        this.verifyFileIsReadable();
        return (httpRequest, method, url, formParams) -> {};
    }

    protected IdentityTokenRequest getRequest() {
        return new IdentityTokenRequest();
    }

    @Override
    public HttpConstants.HttpMethods getHttpMethod() {
        return HttpConstants.HttpMethods.GET;
    }

    @Override
    public String getScope() {
        return null;
    }
}

