/*
 * Decompiled with CFR 0.152.
 */
package com.here.account.http.apache;

import com.here.account.http.HttpConstants;
import com.here.account.http.HttpException;
import com.here.account.http.HttpProvider;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;

public class ApacheHttpClientProvider
implements HttpProvider {
    private final CloseableHttpClient httpClient;
    private final boolean doCloseHttpClient;

    public static Builder builder() {
        return new Builder();
    }

    private HttpRequestBase getRequestNoAuth(String method, String url) {
        URI uri;
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("malformed URL: " + e, e);
        }
        HttpGet apacheRequest = null;
        if (method.equals("GET")) {
            apacheRequest = new HttpGet(uri);
        } else if (method.equals("POST")) {
            apacheRequest = new HttpPost(uri);
        } else if (method.equals("PUT")) {
            apacheRequest = new HttpPut(uri);
        } else if (method.equals("DELETE")) {
            apacheRequest = new HttpDelete(uri);
        } else if (method.equals("HEAD")) {
            apacheRequest = new HttpHead(uri);
        } else if (method.equals("OPTIONS")) {
            apacheRequest = new HttpOptions(uri);
        } else if (method.equals("TRACE")) {
            apacheRequest = new HttpTrace(uri);
        } else if (method.equals("PATCH")) {
            apacheRequest = new HttpPatch(uri);
        } else {
            throw new IllegalArgumentException("no support for request method=" + method);
        }
        return apacheRequest;
    }

    private void addApacheRequestEntity(HttpRequestBase apacheRequest, String method, String requestBodyJson, Map<String, List<String>> formParams) {
        HttpEntityEnclosingRequestBase apacheRequestSupportsEntity;
        HttpEntityEnclosingRequestBase httpEntityEnclosingRequestBase = apacheRequestSupportsEntity = apacheRequest instanceof HttpEntityEnclosingRequestBase ? (HttpEntityEnclosingRequestBase)apacheRequest : null;
        if (null != formParams && formParams.size() > 0) {
            if (null == apacheRequestSupportsEntity) {
                throw new IllegalArgumentException("no formParams permitted for method " + method);
            }
            apacheRequestSupportsEntity.addHeader("Content-Type", "application/x-www-form-urlencoded");
            ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, List<String>> entry : formParams.entrySet()) {
                String value;
                String key = entry.getKey();
                List<String> valueList = entry.getValue();
                if (null == key || null == valueList || valueList.size() <= 0 || null == (value = valueList.get(0))) continue;
                BasicNameValuePair nameValuePair = new BasicNameValuePair(key, value);
                parameters.add(nameValuePair);
            }
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(parameters, HttpConstants.ENCODING_CHARSET);
            apacheRequestSupportsEntity.setEntity((HttpEntity)entity);
        } else if (null != requestBodyJson) {
            if (null == apacheRequestSupportsEntity) {
                throw new IllegalArgumentException("no JSON request body permitted for method " + method);
            }
            apacheRequestSupportsEntity.addHeader("Content-Type", "application/json");
            byte[] bodyBytes = requestBodyJson.getBytes(HttpConstants.ENCODING_CHARSET);
            if (null != bodyBytes) {
                BasicHttpEntity entity = new BasicHttpEntity();
                entity.setContent((InputStream)new ByteArrayInputStream(bodyBytes));
                entity.setContentLength((long)bodyBytes.length);
                apacheRequestSupportsEntity.setEntity((HttpEntity)entity);
            }
        }
    }

    @Override
    public HttpProvider.HttpRequest getRequest(HttpProvider.HttpRequestAuthorizer httpRequestAuthorizer, String method, String url, String requestBodyJson) {
        HttpRequestBase apacheRequest = this.getRequestNoAuth(method, url);
        ApacheHttpClientRequest request = new ApacheHttpClientRequest(apacheRequest);
        Map<String, List<String>> formParams = null;
        httpRequestAuthorizer.authorize(request, method, url, formParams);
        this.addApacheRequestEntity(apacheRequest, method, requestBodyJson, null);
        return request;
    }

    @Override
    public HttpProvider.HttpRequest getRequest(HttpProvider.HttpRequestAuthorizer httpRequestAuthorizer, String method, String url, Map<String, List<String>> formParams) {
        HttpRequestBase apacheRequest = this.getRequestNoAuth(method, url);
        ApacheHttpClientRequest request = new ApacheHttpClientRequest(apacheRequest);
        httpRequestAuthorizer.authorize(request, method, url, formParams);
        this.addApacheRequestEntity(apacheRequest, method, null, formParams);
        return request;
    }

    private ApacheHttpClientProvider(CloseableHttpClient httpClient, boolean doCloseHttpClient) {
        this.httpClient = httpClient;
        this.doCloseHttpClient = doCloseHttpClient;
    }

    @Override
    public void close() throws IOException {
        if (this.doCloseHttpClient && null != this.httpClient) {
            this.httpClient.close();
        }
    }

    @Override
    public HttpProvider.HttpResponse execute(HttpProvider.HttpRequest httpRequest) throws HttpException, IOException {
        if (!(httpRequest instanceof ApacheHttpClientRequest)) {
            throw new IllegalArgumentException("httpRequest is not of expected type; use " + this.getClass() + ".getRequest(..) to get a request of the expected type");
        }
        HttpRequestBase httpRequestBase = ((ApacheHttpClientRequest)httpRequest).getHttpRequestBase();
        HttpContext httpContext = null;
        try {
            CloseableHttpResponse apacheHttpResponse = this.httpClient.execute((HttpUriRequest)httpRequestBase, httpContext);
            return new ApacheHttpClientResponse((HttpResponse)apacheHttpResponse);
        }
        catch (ClientProtocolException e) {
            throw new HttpException("trouble: " + (Object)((Object)e), e);
        }
    }

    private static class ApacheHttpClientResponse
    implements HttpProvider.HttpResponse {
        private final HttpResponse apacheHttpResponse;

        private ApacheHttpClientResponse(HttpResponse apacheHttpResponse) {
            this.apacheHttpResponse = apacheHttpResponse;
        }

        @Override
        public int getStatusCode() {
            return this.apacheHttpResponse.getStatusLine().getStatusCode();
        }

        @Override
        public InputStream getResponseBody() throws IOException {
            HttpEntity httpEntity = this.apacheHttpResponse.getEntity();
            if (null != httpEntity) {
                return httpEntity.getContent();
            }
            return null;
        }

        @Override
        public long getContentLength() {
            HttpEntity httpEntity = this.apacheHttpResponse.getEntity();
            if (null != httpEntity) {
                return httpEntity.getContentLength();
            }
            return 0L;
        }

        @Override
        public Map<String, List<String>> getHeaders() {
            Header[] headers = this.apacheHttpResponse.getAllHeaders();
            HashMap<String, List<String>> ret = new HashMap<String, List<String>>();
            for (Header header : headers) {
                if (ret.containsKey(header.getName())) {
                    ((List)ret.get(header.getName())).add(header.getValue());
                    continue;
                }
                ArrayList<String> values = new ArrayList<String>();
                values.add(header.getValue());
                ret.put(header.getName(), values);
            }
            return ret;
        }
    }

    private static class ApacheHttpClientRequest
    implements HttpProvider.HttpRequest {
        private final HttpRequestBase httpRequestBase;

        private ApacheHttpClientRequest(HttpRequestBase httpRequestBase) {
            this.httpRequestBase = httpRequestBase;
        }

        private HttpRequestBase getHttpRequestBase() {
            return this.httpRequestBase;
        }

        @Override
        public void addAuthorizationHeader(String value) {
            this.httpRequestBase.addHeader("Authorization", value);
        }

        @Override
        public void addHeader(String name, String value) {
            this.httpRequestBase.addHeader(name, value);
        }
    }

    public static class Builder {
        private RequestConfig.Builder apacheConfigBuilder = RequestConfig.custom();
        private CloseableHttpClient httpClient;
        private boolean doCloseHttpClient = true;

        private Builder() {
            this.setConnectionTimeoutInMs(5000);
            this.setRequestTimeoutInMs(5000);
        }

        public Builder setHttpClient(CloseableHttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public Builder setDoCloseHttpClient(boolean doCloseHttpClient) {
            this.doCloseHttpClient = doCloseHttpClient;
            return this;
        }

        public Builder setRequestTimeoutInMs(int requestTimeoutInMs) {
            this.apacheConfigBuilder.setSocketTimeout(requestTimeoutInMs);
            return this;
        }

        public Builder setConnectionTimeoutInMs(int connectionTimeoutInMs) {
            this.apacheConfigBuilder.setConnectTimeout(connectionTimeoutInMs).setConnectionRequestTimeout(connectionTimeoutInMs);
            return this;
        }

        public HttpProvider build() {
            CloseableHttpClient client = this.httpClient != null ? this.httpClient : HttpClientBuilder.create().setDefaultRequestConfig(this.apacheConfigBuilder.build()).build();
            return new ApacheHttpClientProvider(client, this.doCloseHttpClient);
        }
    }
}

