/*
 * Decompiled with CFR 0.152.
 */
package com.here.account.oauth2.retry;

import com.here.account.http.HttpProvider;
import com.here.account.oauth2.retry.RetryContext;
import com.here.account.oauth2.retry.RetryPolicy;
import com.here.account.oauth2.retry.Retryable;
import java.util.logging.Logger;

public class RetryExecutor {
    private final RetryPolicy retryPolicy;
    private static final Logger LOGGER = Logger.getLogger(RetryExecutor.class.getName());

    public RetryExecutor(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
    }

    public HttpProvider.HttpResponse execute(Retryable retryable) throws Exception {
        RetryContext retryContext = new RetryContext();
        while (true) {
            try {
                HttpProvider.HttpResponse httpResponse = retryable.execute();
                retryContext.setLastRetryResponse(httpResponse);
                retryContext.setLastException(null);
            }
            catch (Exception e) {
                retryContext.setLastException(e);
            }
            if (!this.retryPolicy.shouldRetry(retryContext)) break;
            retryContext.incrementRetryCount();
            int waitInterval = this.retryPolicy.getNextRetryIntervalMillis(retryContext);
            LOGGER.warning("Retrying after - " + waitInterval + " milliseconds...");
            try {
                Thread.sleep(waitInterval);
            }
            catch (InterruptedException e) {
                LOGGER.warning("Got InterruptedException while waiting to retry.");
            }
        }
        if (retryContext.getLastException() != null) {
            throw retryContext.getLastException();
        }
        return retryContext.getLastRetryResponse();
    }
}

