/*
 * Decompiled with CFR 0.152.
 */
package com.here.account.auth;

import com.here.account.http.HttpProvider;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class OAuth2Authorizer
implements HttpProvider.HttpRequestAuthorizer {
    private static final String BEARER_SPACE = "Bearer ";
    private final String bearerSpaceAccessToken;
    private final Supplier<String> accessTokenSupplier;

    public OAuth2Authorizer(String accessToken) {
        this.bearerSpaceAccessToken = BEARER_SPACE + accessToken;
        this.accessTokenSupplier = null;
    }

    public OAuth2Authorizer(Supplier<String> accessTokenSupplier) {
        this.bearerSpaceAccessToken = null;
        this.accessTokenSupplier = accessTokenSupplier;
    }

    @Override
    public void authorize(HttpProvider.HttpRequest httpRequest, String method, String url, Map<String, List<String>> formParams) {
        if (null != this.bearerSpaceAccessToken) {
            httpRequest.addAuthorizationHeader(this.bearerSpaceAccessToken);
        } else {
            httpRequest.addAuthorizationHeader(BEARER_SPACE + this.accessTokenSupplier.get());
        }
    }
}

