/*
 * Decompiled with CFR 0.152.
 */
package com.here.account.oauth2;

import com.here.account.auth.provider.ClientAuthorizationProviderChain;
import com.here.account.http.HttpProvider;
import com.here.account.http.apache.ApacheHttpClientProvider;
import com.here.account.oauth2.AccessTokenProvider;
import com.here.account.oauth2.AccessTokenRequest;
import com.here.account.oauth2.AccessTokenResponse;
import com.here.account.oauth2.AccessTokenSupplier;
import com.here.account.oauth2.ClientAuthorizationRequestProvider;
import com.here.account.oauth2.Fresh;
import com.here.account.oauth2.HereAccount;
import com.here.account.oauth2.TokenEndpoint;
import com.here.account.oauth2.retry.NoRetryPolicy;
import com.here.account.oauth2.retry.RetryPolicy;
import com.here.account.util.JacksonSerializer;
import com.here.account.util.Serializer;
import com.here.account.util.SettableSystemClock;
import java.io.Closeable;
import java.io.IOException;
import java.util.function.Supplier;

public class HereAccessTokenProvider
implements AccessTokenSupplier,
Closeable,
AccessTokenProvider {
    private final Serializer serializer;
    private final HttpProvider httpProvider;
    private final boolean doCloseHttpProvider;
    private final TokenEndpoint tokenEndpoint;
    private final Supplier<AccessTokenRequest> accessTokenRequestSupplier;
    private final Fresh<AccessTokenResponse> fresh;

    public static Builder builder() {
        return new Builder();
    }

    private HereAccessTokenProvider(Serializer serializer, ClientAuthorizationRequestProvider credentials, HttpProvider httpProvider, boolean doCloseHttpProvider, boolean alwaysRequestNewToken, RetryPolicy retryPolicy) {
        this.serializer = serializer;
        this.httpProvider = httpProvider;
        this.doCloseHttpProvider = doCloseHttpProvider;
        this.tokenEndpoint = HereAccount.getTokenEndpoint(httpProvider, credentials, this.serializer, retryPolicy);
        this.accessTokenRequestSupplier = () -> credentials.getNewAccessTokenRequest();
        this.fresh = alwaysRequestNewToken ? null : this.tokenEndpoint.requestAutoRefreshingToken(this.accessTokenRequestSupplier);
    }

    @Override
    public String get() {
        return this.getAccessToken();
    }

    @Override
    public String getAccessToken() {
        return this.getAccessTokenResponse().getAccessToken();
    }

    public AccessTokenResponse getAccessTokenResponse() {
        if (null != this.fresh) {
            return this.fresh.get();
        }
        return this.tokenEndpoint.requestToken(this.accessTokenRequestSupplier.get());
    }

    @Override
    public void close() throws IOException {
        try {
            if (null != this.fresh) {
                this.fresh.close();
            }
        }
        finally {
            if (this.doCloseHttpProvider && null != this.httpProvider) {
                this.httpProvider.close();
            }
        }
    }

    public static class Builder {
        private ClientAuthorizationRequestProvider clientAuthorizationRequestProvider;
        private HttpProvider httpProvider;
        private boolean alwaysRequestNewToken = false;
        private Serializer serializer;
        private RetryPolicy retryPolicy;

        private Builder() {
        }

        public Builder setClientAuthorizationRequestProvider(ClientAuthorizationRequestProvider clientAuthorizationRequestProvider) {
            this.clientAuthorizationRequestProvider = clientAuthorizationRequestProvider;
            return this;
        }

        public Builder setHttpProvider(HttpProvider httpProvider) {
            this.httpProvider = httpProvider;
            return this;
        }

        public Builder setAlwaysRequestNewToken(boolean alwaysRequestNewToken) {
            this.alwaysRequestNewToken = alwaysRequestNewToken;
            return this;
        }

        public Builder setSerializer(Serializer serializer) {
            this.serializer = serializer;
            return this;
        }

        public Builder setRetryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = retryPolicy;
            return this;
        }

        public HereAccessTokenProvider build() {
            if (null == this.clientAuthorizationRequestProvider) {
                SettableSystemClock clock = new SettableSystemClock();
                this.clientAuthorizationRequestProvider = ClientAuthorizationProviderChain.getNewDefaultClientCredentialsProviderChain(clock);
            }
            boolean doCloseHttpProvider = false;
            if (null == this.httpProvider) {
                this.httpProvider = ApacheHttpClientProvider.builder().build();
                doCloseHttpProvider = true;
            }
            if (null == this.serializer) {
                this.serializer = new JacksonSerializer();
            }
            if (null == this.retryPolicy) {
                this.retryPolicy = new NoRetryPolicy();
            }
            return new HereAccessTokenProvider(this.serializer, this.clientAuthorizationRequestProvider, this.httpProvider, doCloseHttpProvider, this.alwaysRequestNewToken, this.retryPolicy);
        }
    }
}

