/*
 * Decompiled with CFR 0.152.
 */
package com.here.account.auth.provider;

import com.here.account.auth.provider.ClientCredentialsGrantRequestProvider;
import com.here.account.auth.provider.DefaultHereConfigFiles;
import com.here.account.auth.provider.FromHereCredentialsIniStream;
import com.here.account.auth.provider.RequestProviderException;
import com.here.account.http.HttpConstants;
import com.here.account.http.HttpProvider;
import com.here.account.oauth2.ClientAuthorizationRequestProvider;
import com.here.account.util.Clock;
import com.here.account.util.SettableSystemClock;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Objects;

public class FromHereCredentialsIniFile
extends ClientCredentialsGrantRequestProvider
implements ClientAuthorizationRequestProvider {
    private static final String CREDENTIALS_DOT_INI_FILENAME = "credentials.ini";
    private final File file;
    private final String sectionName;

    public FromHereCredentialsIniFile(Clock clock) {
        this(clock, FromHereCredentialsIniFile.getDefaultHereCredentialsIniFile(), "default");
    }

    public FromHereCredentialsIniFile() {
        this(FromHereCredentialsIniFile.getDefaultHereCredentialsIniFile(), "default");
    }

    public FromHereCredentialsIniFile(File file, String sectionName) {
        this(new SettableSystemClock(), file, sectionName);
    }

    public FromHereCredentialsIniFile(Clock clock, File file, String sectionName) {
        super(clock);
        Objects.requireNonNull(file, "file is required");
        this.file = file;
        this.sectionName = sectionName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ClientAuthorizationRequestProvider getDelegate() {
        try (FileInputStream inputStream = new FileInputStream(this.file);){
            FromHereCredentialsIniStream fromHereCredentialsIniStream = new FromHereCredentialsIniStream(this.getClock(), inputStream, this.sectionName);
            return fromHereCredentialsIniStream;
        }
        catch (IOException e) {
            throw new RequestProviderException("trouble FromFile " + e, e);
        }
    }

    protected File getFile() {
        return this.file;
    }

    protected static File getDefaultHereCredentialsIniFile() {
        return DefaultHereConfigFiles.getDefaultHereConfigFile(CREDENTIALS_DOT_INI_FILENAME);
    }

    @Override
    public String getTokenEndpointUrl() {
        return this.getDelegate().getTokenEndpointUrl();
    }

    @Override
    public HttpProvider.HttpRequestAuthorizer getClientAuthorizer() {
        return this.getDelegate().getClientAuthorizer();
    }

    @Override
    public HttpConstants.HttpMethods getHttpMethod() {
        return HttpConstants.HttpMethods.POST;
    }

    @Override
    public String getScope() {
        return this.getDelegate().getScope();
    }
}

