/*
 * Decompiled with CFR 0.152.
 */
package com.here.account.http.java;

import com.here.account.http.HttpConstants;
import com.here.account.http.HttpException;
import com.here.account.http.HttpProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JavaHttpProvider
implements HttpProvider {
    private JavaHttpProvider() {
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public HttpProvider.HttpRequest getRequest(HttpProvider.HttpRequestAuthorizer httpRequestAuthorizer, String method, String url, String requestBodyJson) {
        JavaHttpRequest httpRequest = null == requestBodyJson ? new JavaHttpRequest(method, url) : new JavaHttpRequest(method, url, requestBodyJson);
        httpRequestAuthorizer.authorize(httpRequest, method, url, null);
        return httpRequest;
    }

    @Override
    public HttpProvider.HttpRequest getRequest(HttpProvider.HttpRequestAuthorizer httpRequestAuthorizer, String method, String url, Map<String, List<String>> formParams) {
        JavaHttpRequest httpRequest = null == formParams ? new JavaHttpRequest(method, url) : new JavaHttpRequest(method, url, formParams);
        httpRequestAuthorizer.authorize(httpRequest, method, url, formParams);
        return httpRequest;
    }

    protected long getContentLength(HttpURLConnection connection) {
        String contentLengthString = connection.getHeaderField("Content-Length");
        return Long.parseLong(contentLengthString);
    }

    protected HttpURLConnection getHttpUrlConnection(String urlString) throws IOException {
        URL url = new URL(urlString);
        return (HttpURLConnection)url.openConnection();
    }

    @Override
    public HttpProvider.HttpResponse execute(HttpProvider.HttpRequest httpRequest) throws HttpException, IOException {
        Map<String, String> additionalHeaders;
        String authorizationHeader;
        if (!(httpRequest instanceof JavaHttpRequest)) {
            throw new IllegalArgumentException("httpRequest is not of expected type; use " + this.getClass() + ".getRequest(..) to get a request of the expected type");
        }
        JavaHttpRequest javaHttpRequest = (JavaHttpRequest)httpRequest;
        HttpURLConnection connection = this.getHttpUrlConnection(javaHttpRequest.getUrl());
        connection.setDoOutput(true);
        connection.setRequestMethod(javaHttpRequest.getMethod());
        byte[] body = javaHttpRequest.getBody();
        if (null != body) {
            connection.setRequestProperty("Content-Type", javaHttpRequest.getContentType());
            connection.setRequestProperty("Content-Length", javaHttpRequest.getContentLength());
        }
        if (null != (authorizationHeader = javaHttpRequest.getAuthorizationHeader())) {
            connection.setRequestProperty("Authorization", authorizationHeader);
        }
        if (null != (additionalHeaders = javaHttpRequest.getAdditionalHeaders())) {
            for (Map.Entry<String, String> entry : additionalHeaders.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                connection.setRequestProperty(key, value);
            }
        }
        if (null != body) {
            Throwable throwable = null;
            try (OutputStream outputStream = connection.getOutputStream();){
                outputStream.write(body);
                outputStream.flush();
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        }
        int statusCode = connection.getResponseCode();
        long l = this.getContentLength(connection);
        Map<String, List<String>> headers = connection.getHeaderFields();
        InputStream inputStream = statusCode < 400 ? connection.getInputStream() : connection.getErrorStream();
        return new JavaHttpResponse(statusCode, l, inputStream, headers);
    }

    protected static byte[] getFormBody(Map<String, List<String>> formParams) throws UnsupportedEncodingException {
        StringBuilder formBuf = new StringBuilder();
        boolean first = true;
        Set<Map.Entry<String, List<String>>> formEntrySet = formParams.entrySet();
        for (Map.Entry<String, List<String>> formEntry : formEntrySet) {
            String key = formEntry.getKey();
            List<String> values = formEntry.getValue();
            String encodedKey = URLEncoder.encode(key, "UTF-8");
            if (null != values && !values.isEmpty()) {
                for (String value : values) {
                    if (first) {
                        first = false;
                    } else {
                        formBuf.append('&');
                    }
                    formBuf.append(encodedKey).append('=').append(URLEncoder.encode(value, "UTF-8"));
                }
                continue;
            }
            if (first) {
                first = false;
            } else {
                formBuf.append('&');
            }
            formBuf.append(encodedKey);
        }
        return formBuf.toString().getBytes(HttpConstants.ENCODING_CHARSET);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static class JavaHttpRequest
    implements HttpProvider.HttpRequest {
        private final String method;
        private final String url;
        private String authorizationHeader;
        private Map<String, String> additionalHeaders;
        private byte[] body;
        private final String contentType;
        private final String contentLength;

        private JavaHttpRequest(String method, String url) {
            this.method = method;
            this.url = url;
            this.additionalHeaders = new HashMap<String, String>();
            this.contentType = null;
            this.body = null;
            this.contentLength = null;
        }

        private JavaHttpRequest(String method, String url, String requestBodyJson) {
            this.method = method;
            this.url = url;
            this.additionalHeaders = new HashMap<String, String>();
            this.contentType = "application/json";
            this.body = requestBodyJson.getBytes(HttpConstants.ENCODING_CHARSET);
            this.contentLength = String.valueOf(this.body.length);
        }

        private JavaHttpRequest(String method, String url, Map<String, List<String>> formParams) {
            this.method = method;
            this.url = url;
            this.additionalHeaders = new HashMap<String, String>();
            try {
                this.contentType = "application/x-www-form-urlencoded";
                this.body = JavaHttpProvider.getFormBody(formParams);
                this.contentLength = String.valueOf(this.body.length);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        public void addAuthorizationHeader(String value) {
            this.authorizationHeader = value;
        }

        @Override
        public void addHeader(String name, String value) {
            this.additionalHeaders.put(name, value);
        }

        public String getMethod() {
            return this.method;
        }

        public String getUrl() {
            return this.url;
        }

        public String getAuthorizationHeader() {
            return this.authorizationHeader;
        }

        public Map<String, String> getAdditionalHeaders() {
            return this.additionalHeaders;
        }

        public byte[] getBody() {
            return this.body;
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getContentLength() {
            return this.contentLength;
        }
    }

    static class JavaHttpResponse
    implements HttpProvider.HttpResponse {
        private final int statusCode;
        private final long contentLength;
        private final InputStream responseBody;
        private final Map<String, List<String>> headers;

        public JavaHttpResponse(int statusCode, long contentLength, InputStream responseBody, Map<String, List<String>> headers) {
            this.statusCode = statusCode;
            this.contentLength = contentLength;
            this.responseBody = responseBody;
            this.headers = headers;
        }

        @Override
        public int getStatusCode() {
            return this.statusCode;
        }

        @Override
        public long getContentLength() {
            return this.contentLength;
        }

        @Override
        public InputStream getResponseBody() throws IOException {
            return this.responseBody;
        }

        @Override
        public Map<String, List<String>> getHeaders() {
            return this.headers;
        }
    }

    public static class Builder {
        private Builder() {
        }

        public HttpProvider build() {
            return new JavaHttpProvider();
        }
    }
}

