/*
 * Decompiled with CFR 0.152.
 */
package com.here.account.oauth2;

import com.here.account.auth.NoAuthorizer;
import com.here.account.client.Client;
import com.here.account.http.HttpConstants;
import com.here.account.http.HttpProvider;
import com.here.account.oauth2.AccessTokenException;
import com.here.account.oauth2.AccessTokenRequest;
import com.here.account.oauth2.AccessTokenResponse;
import com.here.account.oauth2.ClientAuthorizationRequestProvider;
import com.here.account.oauth2.ClientCredentialsGrantRequest;
import com.here.account.oauth2.ClientCredentialsProvider;
import com.here.account.oauth2.ErrorResponse;
import com.here.account.oauth2.FileAccessTokenResponse;
import com.here.account.oauth2.Fresh;
import com.here.account.oauth2.RequestExecutionException;
import com.here.account.oauth2.ResponseParsingException;
import com.here.account.oauth2.TokenEndpoint;
import com.here.account.oauth2.bo.TimestampResponse;
import com.here.account.oauth2.retry.NoRetryPolicy;
import com.here.account.oauth2.retry.RetryPolicy;
import com.here.account.util.Clock;
import com.here.account.util.JacksonSerializer;
import com.here.account.util.RefreshableResponseProvider;
import com.here.account.util.Serializer;
import com.here.account.util.SettableClock;
import com.here.account.util.SettableSystemClock;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.Logger;

public class HereAccount {
    private HereAccount() {
    }

    public static TokenEndpoint getTokenEndpoint(HttpProvider httpProvider, ClientCredentialsProvider clientCredentialsProvider) {
        return new TokenEndpointImpl(HereAccount.reuseClock(clientCredentialsProvider), httpProvider, clientCredentialsProvider, new JacksonSerializer(), new NoRetryPolicy());
    }

    public static TokenEndpoint getTokenEndpoint(HttpProvider httpProvider, ClientAuthorizationRequestProvider clientAuthorizationRequestProvider) {
        return HereAccount.getTokenEndpoint(HereAccount.reuseClock(clientAuthorizationRequestProvider), httpProvider, clientAuthorizationRequestProvider, new JacksonSerializer(), new NoRetryPolicy());
    }

    private static Clock reuseClock(ClientAuthorizationRequestProvider clientAuthorizationRequestProvider) {
        Clock clock = null;
        if (null != clientAuthorizationRequestProvider) {
            clock = clientAuthorizationRequestProvider.getClock();
        }
        if (null == clock) {
            clock = new SettableSystemClock();
        }
        return clock;
    }

    private static Clock reuseClock(ClientCredentialsProvider clientCredentialsProvider) {
        Clock clock = null;
        if (null != clientCredentialsProvider) {
            clock = clientCredentialsProvider.getClock();
        }
        if (null == clock) {
            clock = new SettableSystemClock();
        }
        return clock;
    }

    @Deprecated
    public static TokenEndpoint getTokenEndpoint(HttpProvider httpProvider, ClientAuthorizationRequestProvider clientAuthorizationRequestProvider, Serializer serializer) {
        return HereAccount.getTokenEndpoint(HereAccount.reuseClock(clientAuthorizationRequestProvider), httpProvider, clientAuthorizationRequestProvider, serializer, new NoRetryPolicy());
    }

    static TokenEndpoint getTokenEndpoint(HttpProvider httpProvider, ClientAuthorizationRequestProvider clientAuthorizationRequestProvider, Serializer serializer, RetryPolicy retryPolicy) {
        return HereAccount.getTokenEndpoint(HereAccount.reuseClock(clientAuthorizationRequestProvider), httpProvider, clientAuthorizationRequestProvider, serializer, retryPolicy);
    }

    private static TokenEndpoint getTokenEndpoint(Clock clock, HttpProvider httpProvider, ClientAuthorizationRequestProvider clientCredentialsProvider, Serializer serializer, RetryPolicy retryPolicy) {
        return new TokenEndpointImpl(clock, httpProvider, clientCredentialsProvider, serializer, retryPolicy);
    }

    private static RefreshableResponseProvider<AccessTokenResponse> getRefreshableClientTokenProvider(Clock clock, TokenEndpoint tokenEndpoint, Supplier<AccessTokenRequest> accessTokenRequestFactory) throws AccessTokenException, RequestExecutionException, ResponseParsingException {
        return new RefreshableResponseProvider<AccessTokenResponse>(clock, null, tokenEndpoint.requestToken(accessTokenRequestFactory.get()), previous -> {
            try {
                return tokenEndpoint.requestToken((AccessTokenRequest)accessTokenRequestFactory.get());
            }
            catch (AccessTokenException | RequestExecutionException | ResponseParsingException e) {
                throw new RuntimeException("trouble refresh: " + e, e);
            }
        }, RefreshableResponseProvider.getScheduledExecutorServiceSize1());
    }

    @Deprecated
    static void nullSafeCloseThrowingUnchecked(Closeable closeable) {
        if (null != closeable) {
            try {
                closeable.close();
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(ioe);
            }
        }
    }

    private static class TokenEndpointImpl
    implements TokenEndpoint {
        private static final Logger LOGGER = Logger.getLogger(TokenEndpointImpl.class.getName());
        @Deprecated
        public static final String HTTP_METHOD_POST = "POST";
        private final boolean currentTimeMillisSettable;
        private final Clock clock;
        private final SettableClock settableClock;
        private final String timestampUrl;
        private final boolean requestTokenFromFile;
        private final Client client;
        private final HttpProvider httpProvider;
        private final HttpConstants.HttpMethods httpMethod;
        private final String url;
        private final String scope;
        private final HttpProvider.HttpRequestAuthorizer clientAuthorizer;
        private final Serializer serializer;
        private static final String FILE_URL_START = "file://";
        private static final int CLOCK_SKEW_STATUS_CODE = 401;
        private static final int CLOCK_SKEW_ERROR_CODE = 401204;
        private static final long CONVERT_SECONDS_TO_MILLISECONDS = 1000L;
        private static final String SLASH_TOKEN = "/oauth2/token";
        private static final String SLASH_TIMESTAMP = "/timestamp";
        private final NoAuthorizer noAuthorizer = new NoAuthorizer();

        private TokenEndpointImpl(Clock clock, HttpProvider httpProvider, ClientAuthorizationRequestProvider clientAuthorizationProvider, Serializer serializer, RetryPolicy retryPolicy) {
            this.clock = clock;
            this.url = clientAuthorizationProvider.getTokenEndpointUrl();
            this.clientAuthorizer = clientAuthorizationProvider.getClientAuthorizer();
            this.httpMethod = clientAuthorizationProvider.getHttpMethod();
            this.scope = clientAuthorizationProvider.getScope();
            this.client = Client.builder().withHttpProvider(httpProvider).withClientAuthorizer(this.clientAuthorizer).withSerializer(serializer).withRetryPolicy(retryPolicy).build();
            this.httpProvider = httpProvider;
            this.serializer = serializer;
            this.requestTokenFromFile = null != this.url && this.url.startsWith(FILE_URL_START);
            this.currentTimeMillisSettable = clock instanceof SettableClock && null != this.url && this.url.endsWith(SLASH_TOKEN);
            if (this.currentTimeMillisSettable) {
                this.settableClock = (SettableClock)clock;
                this.timestampUrl = this.url.substring(0, this.url.length() - SLASH_TOKEN.length()) + SLASH_TIMESTAMP;
            } else {
                this.settableClock = null;
                this.timestampUrl = null;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected AccessTokenResponse requestTokenFromFile() throws RequestExecutionException {
            try (InputStream is = new URL(this.url).openStream();){
                AccessTokenResponse accessTokenResponse = this.serializer.jsonToPojo(is, FileAccessTokenResponse.class);
                return accessTokenResponse;
            }
            catch (IOException e) {
                throw new RequestExecutionException(e);
            }
        }

        @Override
        public AccessTokenResponse requestToken(AccessTokenRequest authorizationRequest) throws AccessTokenException, RequestExecutionException, ResponseParsingException {
            if (this.requestTokenFromFile) {
                return this.requestTokenFromFile();
            }
            return this.requestTokenHttp(authorizationRequest, 1);
        }

        protected AccessTokenResponse requestTokenHttp(AccessTokenRequest authorizationRequest, int retryFixableErrorsCount) throws AccessTokenException, RequestExecutionException, ResponseParsingException {
            String method = this.httpMethod.getMethod();
            if (null != this.scope && null == authorizationRequest.getScope()) {
                authorizationRequest.setScope(this.scope);
            }
            HttpProvider.HttpRequest httpRequest = this.httpProvider.getRequest(this.clientAuthorizer, method, this.url, authorizationRequest.toFormParams());
            this.addAdditionalHeaders(httpRequest, authorizationRequest);
            try {
                AccessTokenResponse response = this.client.sendMessage(httpRequest, AccessTokenResponse.class, ErrorResponse.class, (statusCode, errorResponse) -> new AccessTokenException((int)statusCode, (ErrorResponse)errorResponse));
                return response;
            }
            catch (AccessTokenException e) {
                return this.handleFixableErrors(authorizationRequest, retryFixableErrorsCount, e);
            }
        }

        private void addAdditionalHeaders(HttpProvider.HttpRequest httpRequest, AccessTokenRequest authorizationRequest) {
            String correlationId;
            Map<String, String> headers = authorizationRequest.getAdditionalHeaders();
            if (null != headers) {
                for (Map.Entry<String, String> header : headers.entrySet()) {
                    httpRequest.addHeader(header.getKey(), header.getValue());
                }
            }
            if (null != (correlationId = authorizationRequest.getCorrelationId())) {
                httpRequest.addHeader("X-Correlation-ID", correlationId);
            }
        }

        protected boolean canFixClockSkew(int retryFixableErrorsCount, AccessTokenException e) {
            ErrorResponse errorResponse;
            return this.currentTimeMillisSettable && retryFixableErrorsCount > 0 && null != e && 401 == e.getStatusCode() && null != (errorResponse = e.getErrorResponse()) && 401204 == errorResponse.getErrorCode();
        }

        protected TimestampResponse getServerTimestamp() {
            String method = HttpConstants.HttpMethods.GET.getMethod();
            HttpProvider.HttpRequest httpRequest = this.httpProvider.getRequest((HttpProvider.HttpRequestAuthorizer)this.noAuthorizer, method, this.timestampUrl, (String)null);
            TimestampResponse timestampResponse = this.client.sendMessage(httpRequest, TimestampResponse.class, ErrorResponse.class, (statusCode, errorResponse2) -> new AccessTokenException((int)statusCode, (ErrorResponse)errorResponse2));
            return timestampResponse;
        }

        protected AccessTokenResponse handleFixableErrors(AccessTokenRequest authorizationRequest, int retryFixableErrorsCount, AccessTokenException e) {
            if (this.canFixClockSkew(retryFixableErrorsCount, e)) {
                try {
                    TimestampResponse timestampResponse = this.getServerTimestamp();
                    long timestamp = timestampResponse.getTimestamp();
                    this.settableClock.setCurrentTimeMillis(timestamp * 1000L);
                }
                catch (Exception e2) {
                    LOGGER.warning(() -> "correcting clock skew, trouble getting timestamp: " + e2);
                    throw e;
                }
                return this.requestTokenHttp(authorizationRequest, retryFixableErrorsCount - 1);
            }
            throw e;
        }

        @Override
        public Fresh<AccessTokenResponse> requestAutoRefreshingToken(Supplier<AccessTokenRequest> requestSupplier) throws AccessTokenException, RequestExecutionException, ResponseParsingException {
            final RefreshableResponseProvider refresher = HereAccount.getRefreshableClientTokenProvider(this.clock, this, requestSupplier);
            return new Fresh<AccessTokenResponse>(){

                @Override
                public AccessTokenResponse get() {
                    return (AccessTokenResponse)refresher.getUnexpiredResponse();
                }

                @Override
                public void close() throws IOException {
                    refresher.shutdown();
                }
            };
        }

        @Override
        public Fresh<AccessTokenResponse> requestAutoRefreshingToken(AccessTokenRequest request) throws AccessTokenException, RequestExecutionException, ResponseParsingException {
            return this.requestAutoRefreshingToken(() -> new ClientCredentialsGrantRequest().setExpiresIn(request.getExpiresIn()).setScope(request.getScope()));
        }
    }
}

