/*
 * Decompiled with CFR 0.152.
 */
package com.here.account.util;

import com.here.account.util.Clock;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class RefreshableResponseProvider<T extends ExpiringResponse> {
    private static final Logger LOG = Logger.getLogger(RefreshableResponseProvider.class.getName());
    static final long MIN_REFRESH_SECONDS = 30L;
    static final long REFRESH_BACKOFF_SECONDS = 60L;
    static final long RETRY_FAIL_SECONDS = 5L;
    private final ResponseRefresher<T> refreshResponseFunction;
    private final ScheduledExecutorService scheduledExecutorService;
    private final Long refreshIntervalMillis;
    private boolean started;
    private volatile T refreshResponse;
    private Clock clock;

    public RefreshableResponseProvider(Long refreshIntervalMillis, T initialResponse, ResponseRefresher<T> refreshResponseFunction) {
        this(Clock.SYSTEM, refreshIntervalMillis, initialResponse, refreshResponseFunction, RefreshableResponseProvider.getScheduledExecutorServiceSize1());
    }

    public static ScheduledExecutorService getScheduledExecutorServiceSize1() {
        return Executors.newScheduledThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, "here-auth-refresh-%s");
                thread.setDaemon(true);
                return thread;
            }
        });
    }

    public RefreshableResponseProvider(Clock clock, Long refreshIntervalMillis, T initialResponse, ResponseRefresher<T> refreshResponseFunction, ScheduledExecutorService scheduledExecutorService) {
        Objects.requireNonNull(clock, "clock cannot be null");
        Objects.requireNonNull(initialResponse, "initialResponse cannot be null");
        Objects.requireNonNull(refreshResponseFunction, "refreshResponseFunction cannot be null");
        Objects.requireNonNull(scheduledExecutorService, "scheduledExecutorService cannot be null");
        Objects.requireNonNull(initialResponse.getExpiresIn(), "initialResponse.getExpiresIn() cannot be null");
        Objects.requireNonNull(initialResponse.getStartTimeMilliseconds(), "initialResponse.getStartTimeMilliseconds() cannot be null");
        this.clock = clock;
        this.refreshIntervalMillis = refreshIntervalMillis;
        this.refreshResponse = initialResponse;
        this.refreshResponseFunction = refreshResponseFunction;
        this.scheduledExecutorService = scheduledExecutorService;
        this.started = true;
        this.scheduleTokenRefresh(this.nextRefreshInterval());
    }

    public void shutdown() {
        if (this.started) {
            try {
                LOG.info("Shutting down refresh token thread");
                this.scheduledExecutorService.shutdown();
            }
            finally {
                this.started = false;
            }
        }
    }

    public T getUnexpiredResponse() {
        return this.refreshResponse;
    }

    long nextRefreshInterval() {
        if (this.refreshIntervalMillis != null) {
            return this.refreshIntervalMillis;
        }
        return TimeUnit.SECONDS.toMillis(Math.max(this.refreshResponse.getExpiresIn() - 60L, 30L));
    }

    protected void scheduleTokenRefresh(long millis) {
        if (!this.started) {
            LOG.info("Refresh token thread shutdown, not scheduling");
            return;
        }
        LOG.info("Scheduling next token refresh in " + millis + " milliseconds");
        this.clock.schedule(this.scheduledExecutorService, new Runnable(){

            @Override
            public void run() {
                RefreshableResponseProvider.this.refreshToken();
            }
        }, millis);
    }

    private void refreshToken() {
        LOG.info(String.format("Refreshing HERE auth token (last successful response %s seconds)", TimeUnit.SECONDS.convert(this.clock.currentTimeMillis() - this.refreshResponse.getStartTimeMilliseconds(), TimeUnit.MILLISECONDS)));
        try {
            this.refreshResponse = this.refreshResponseFunction.refresh(this.refreshResponse);
            this.scheduleTokenRefresh(this.nextRefreshInterval());
        }
        catch (Exception exp) {
            LOG.warning("Failed to refresh HERE token " + exp);
            this.scheduleTokenRefresh(Math.min(this.nextRefreshInterval(), TimeUnit.SECONDS.toMillis(5L)));
        }
    }

    public static interface ExpiringResponse {
        public Long getExpiresIn();

        public Long getStartTimeMilliseconds();
    }

    public static interface ResponseRefresher<T extends ExpiringResponse> {
        public T refresh(T var1);
    }
}

