/*
 * Decompiled with CFR 0.152.
 */
package com.here.account.client;

import com.here.account.http.HttpProvider;
import com.here.account.oauth2.ErrorResponse;
import com.here.account.oauth2.RequestExecutionException;
import com.here.account.oauth2.ResponseParsingException;
import com.here.account.oauth2.retry.NoRetryPolicy;
import com.here.account.oauth2.retry.RetryExecutor;
import com.here.account.oauth2.retry.RetryPolicy;
import com.here.account.oauth2.retry.Retryable;
import com.here.account.olp.OlpHttpMessage;
import com.here.account.util.CloseUtil;
import com.here.account.util.Serializer;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.function.BiFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class Client {
    private static final Logger LOGGER = Logger.getLogger(Client.class.getName());
    private static final Pattern START_PATTERN = Pattern.compile("\\A");
    private static final String LOWERCASE_CONTENT_TYPE_JSON = "application/json".toLowerCase();
    private final HttpProvider httpProvider;
    private final Serializer serializer;
    private final HttpProvider.HttpRequestAuthorizer clientAuthorizer;
    private final RetryExecutor retryExecutor;

    public static Builder builder() {
        return new Builder();
    }

    private Client(HttpProvider httpProvider, Serializer serializer, HttpProvider.HttpRequestAuthorizer clientAuthorizer, RetryPolicy retryPolicy) {
        this.httpProvider = httpProvider;
        this.serializer = serializer;
        this.clientAuthorizer = clientAuthorizer;
        this.retryExecutor = new RetryExecutor(retryPolicy);
    }

    public HttpProvider.HttpRequestAuthorizer getClientAuthorizer() {
        return this.clientAuthorizer;
    }

    public <R, T, U> T sendMessage(String method, String url, R request, Class<T> responseClass, Class<U> errorResponseClass, BiFunction<Integer, U, RuntimeException> newExceptionFunction) throws RequestExecutionException, ResponseParsingException {
        return this.sendMessage(method, url, request, null, responseClass, errorResponseClass, newExceptionFunction);
    }

    public <R, T, U> T sendMessage(String method, String url, R request, Map<String, String> additionalHeaders, Class<T> responseClass, Class<U> errorResponseClass, BiFunction<Integer, U, RuntimeException> newExceptionFunction) throws RequestExecutionException, ResponseParsingException {
        HttpProvider.HttpRequest httpRequest;
        if (null == request) {
            httpRequest = this.httpProvider.getRequest(this.clientAuthorizer, method, url, (String)null);
        } else {
            String jsonBody = this.serializer.objectToJson(request);
            httpRequest = this.httpProvider.getRequest(this.clientAuthorizer, method, url, jsonBody);
        }
        HttpProvider.HttpRequest httpRequestWithAdditonalHeaders = this.addAdditionalHeaders(httpRequest, additionalHeaders);
        return this.sendMessage(httpRequestWithAdditonalHeaders, responseClass, errorResponseClass, newExceptionFunction);
    }

    /*
     * Loose catch block
     */
    public <T, U> T sendMessage(HttpProvider.HttpRequest httpRequest, Class<T> responseClass, Class<U> errorResponseClass, BiFunction<Integer, U, RuntimeException> newExceptionFunction) throws RequestExecutionException, ResponseParsingException {
        U errorResponse;
        int statusCode;
        InputStream jsonInputStream;
        block13: {
            HttpProvider.HttpResponse httpResponse;
            try {
                Retryable retryable = () -> this.httpProvider.execute(httpRequest);
                httpResponse = this.retryExecutor.execute(retryable);
                jsonInputStream = httpResponse.getResponseBody();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RequestExecutionException(e);
            }
            statusCode = httpResponse.getStatusCode();
            String correlationId = this.getCorrelationId(httpResponse);
            if (200 == statusCode || 201 == statusCode || 204 == statusCode) {
                if (204 == statusCode && responseClass.equals(Void.class)) {
                    T t = null;
                    return t;
                }
                T response = this.serializer.jsonToPojo(jsonInputStream, responseClass);
                this.setCorrelationId(response, responseClass, correlationId);
                T t = response;
                return t;
            }
            errorResponse = this.isResponseTypeJson(httpResponse) ? this.serializer.jsonToPojo(jsonInputStream, errorResponseClass) : this.instantiateErrorResponseClass(errorResponseClass, jsonInputStream, statusCode);
            break block13;
            catch (Exception e) {
                throw new ResponseParsingException(e);
            }
        }
        throw newExceptionFunction.apply(statusCode, errorResponse);
        finally {
            CloseUtil.nullSafeCloseThrowingUnchecked(jsonInputStream);
        }
    }

    private boolean isResponseTypeJson(HttpProvider.HttpResponse response) {
        try {
            Map<String, List<String>> headers = response.getHeaders();
            List<String> responseTypes = headers.get("Content-Type");
            if (null == responseTypes || responseTypes.isEmpty()) {
                return true;
            }
            for (String aResponseType : responseTypes) {
                if (!aResponseType.toLowerCase().trim().startsWith(LOWERCASE_CONTENT_TYPE_JSON)) continue;
                return true;
            }
            return false;
        }
        catch (UnsupportedOperationException e) {
            return true;
        }
    }

    private <U> U instantiateErrorResponseClass(Class<U> errorResponseClass, InputStream responseBody, int statusCode) {
        try {
            U errorResponse;
            if (errorResponseClass.isAssignableFrom(ErrorResponse.class)) {
                Constructor<U> ctor = errorResponseClass.getConstructor(String.class, String.class, String.class, Integer.class, Integer.class, String.class);
                errorResponse = ctor.newInstance(null, null, null, statusCode, null, this.convertStreamToString(responseBody));
            } else {
                Constructor<U> ctor = errorResponseClass.getConstructor(new Class[0]);
                errorResponse = ctor.newInstance(new Object[0]);
            }
            return errorResponse;
        }
        catch (NoSuchMethodException nsme) {
            throw new RequestExecutionException("Internal Error: " + errorResponseClass.getName() + " has no default constructor");
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
            throw new RequestExecutionException("Internal Error: " + errorResponseClass.getName() + " cannot be constructed", ex);
        }
    }

    private String convertStreamToString(InputStream is) {
        Scanner s = new Scanner(is, "UTF-8").useDelimiter(START_PATTERN);
        String str = s.hasNext() ? s.next() : "";
        return str.substring(0, Math.min(1024, str.length()));
    }

    private <T> void setCorrelationId(T response, Class<T> responseClass, String correlationId) {
        if (null != correlationId && null != response && OlpHttpMessage.class.isAssignableFrom(responseClass)) {
            ((OlpHttpMessage)response).setCorrelationId(correlationId);
        }
    }

    private String getCorrelationId(HttpProvider.HttpResponse httpResponse) {
        try {
            List<String> values;
            Map<String, List<String>> headers = null != httpResponse ? httpResponse.getHeaders() : null;
            List<String> list = values = null != headers ? headers.get("X-Correlation-ID") : null;
            if (null != values && values.size() > 0) {
                String correlationId = values.get(0);
                if (null != correlationId && LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("X-Correlation-ID: " + correlationId);
                }
                return correlationId;
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return null;
    }

    private HttpProvider.HttpRequest addAdditionalHeaders(HttpProvider.HttpRequest httpRequest, Map<String, String> additionalHeaders) {
        if (null != additionalHeaders) {
            for (Map.Entry<String, String> additionalHeader : additionalHeaders.entrySet()) {
                String name = additionalHeader.getKey();
                String value = additionalHeader.getValue();
                httpRequest.addHeader(name, value);
                if (!"X-Correlation-ID".equals(name) || value == null || !LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.fine("X-Correlation-ID: " + value);
            }
        }
        return httpRequest;
    }

    public static class Builder {
        private HttpProvider httpProvider;
        private Serializer serializer;
        private RetryPolicy retryPolicy;
        private HttpProvider.HttpRequestAuthorizer clientAuthorizer;

        private Builder() {
        }

        public Builder withHttpProvider(HttpProvider httpProvider) {
            this.httpProvider = httpProvider;
            return this;
        }

        public Builder withSerializer(Serializer serializer) {
            this.serializer = serializer;
            return this;
        }

        public Builder withClientAuthorizer(HttpProvider.HttpRequestAuthorizer clientAuthorizer) {
            this.clientAuthorizer = clientAuthorizer;
            return this;
        }

        public Builder withRetryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = retryPolicy;
            return this;
        }

        public Client build() {
            if (null == this.retryPolicy) {
                this.retryPolicy = new NoRetryPolicy();
            }
            return new Client(this.httpProvider, this.serializer, this.clientAuthorizer, this.retryPolicy);
        }
    }
}

