/*
 * Decompiled with CFR 0.152.
 */
package com.here.account.auth;

import com.here.account.auth.OAuth1Signer;
import com.here.account.http.HttpConstants;
import com.here.account.http.HttpProvider;
import com.here.account.oauth2.AccessTokenRequest;
import com.here.account.oauth2.ClientCredentialsGrantRequest;
import com.here.account.oauth2.ClientCredentialsProvider;
import com.here.account.util.Clock;
import com.here.account.util.SettableSystemClock;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Properties;

public class OAuth1ClientCredentialsProvider
implements ClientCredentialsProvider {
    private final Clock clock;
    private final String tokenEndpointUrl;
    private final OAuth1Signer oauth1Signer;
    private final String scope;

    public OAuth1ClientCredentialsProvider(String tokenEndpointUrl, String accessKeyId, String accessKeySecret) {
        this(new SettableSystemClock(), tokenEndpointUrl, accessKeyId, accessKeySecret, null);
    }

    public OAuth1ClientCredentialsProvider(String tokenEndpointUrl, String accessKeyId, String accessKeySecret, String scope) {
        this(new SettableSystemClock(), tokenEndpointUrl, accessKeyId, accessKeySecret, scope);
    }

    public OAuth1ClientCredentialsProvider(Clock clock, String tokenEndpointUrl, String accessKeyId, String accessKeySecret) {
        this(clock, tokenEndpointUrl, accessKeyId, accessKeySecret, null);
    }

    public OAuth1ClientCredentialsProvider(Clock clock, String tokenEndpointUrl, String accessKeyId, String accessKeySecret, String scope) {
        Objects.requireNonNull(clock, "clock is required");
        Objects.requireNonNull(tokenEndpointUrl, "tokenEndpointUrl is required");
        Objects.requireNonNull(accessKeyId, "accessKeyId is required");
        Objects.requireNonNull(accessKeySecret, "accessKeySecret is required");
        this.clock = clock;
        this.tokenEndpointUrl = tokenEndpointUrl;
        this.oauth1Signer = new OAuth1Signer(clock, accessKeyId, accessKeySecret);
        this.scope = scope;
    }

    @Override
    public Clock getClock() {
        return this.clock;
    }

    @Override
    public String getTokenEndpointUrl() {
        return this.tokenEndpointUrl;
    }

    @Override
    public HttpProvider.HttpRequestAuthorizer getClientAuthorizer() {
        return this.oauth1Signer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getPropertiesFromFile(File file) throws IOException {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            Properties properties = new Properties();
            properties.load(inputStream);
            Properties properties2 = properties;
            return properties2;
        }
        finally {
            if (null != inputStream) {
                ((InputStream)inputStream).close();
            }
        }
    }

    @Override
    public AccessTokenRequest getNewAccessTokenRequest() {
        ClientCredentialsGrantRequest req = new ClientCredentialsGrantRequest();
        req.setScope(this.scope);
        return req;
    }

    @Override
    public HttpConstants.HttpMethods getHttpMethod() {
        return HttpConstants.HttpMethods.POST;
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    public static class FromFile
    extends FromProperties {
        public FromFile(File file) throws IOException {
            super(FromFile.getPropertiesFromFile(file));
        }
    }

    public static class FromProperties
    extends OAuth1ClientCredentialsProvider {
        public static final String TOKEN_ENDPOINT_URL_PROPERTY = "here.token.endpoint.url";
        public static final String ACCESS_KEY_ID_PROPERTY = "here.access.key.id";
        public static final String ACCESS_KEY_SECRET_PROPERTY = "here.access.key.secret";
        public static final String TOKEN_SCOPE_PROPERTY = "here.token.scope";

        public FromProperties(Properties properties) {
            super(properties.getProperty(TOKEN_ENDPOINT_URL_PROPERTY), properties.getProperty(ACCESS_KEY_ID_PROPERTY), properties.getProperty(ACCESS_KEY_SECRET_PROPERTY), properties.getProperty(TOKEN_SCOPE_PROPERTY));
        }
    }
}

