/*
 * Decompiled with CFR 0.152.
 */
package com.here.account.auth.provider;

import com.here.account.auth.provider.ClientCredentialsGrantRequestProvider;
import com.here.account.auth.provider.FromSystemProperties;
import com.here.account.auth.provider.RequestProviderException;
import com.here.account.http.HttpConstants;
import com.here.account.http.HttpProvider;
import com.here.account.oauth2.ClientAuthorizationRequestProvider;
import com.here.account.util.Clock;
import com.here.account.util.OAuthConstants;
import com.here.account.util.SettableSystemClock;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Objects;
import java.util.Properties;
import org.ini4j.Ini;
import org.ini4j.Profile;

public class FromHereCredentialsIniStream
extends ClientCredentialsGrantRequestProvider
implements ClientAuthorizationRequestProvider {
    private final Clock clock;
    private final ClientAuthorizationRequestProvider delegate;
    static final String DEFAULT_INI_SECTION_NAME = "default";

    public FromHereCredentialsIniStream(Clock clock, InputStream inputStream) {
        this(clock, inputStream, DEFAULT_INI_SECTION_NAME);
    }

    public FromHereCredentialsIniStream(InputStream inputStream) {
        this(inputStream, DEFAULT_INI_SECTION_NAME);
    }

    public FromHereCredentialsIniStream(InputStream inputStream, String sectionName) {
        this(new SettableSystemClock(), inputStream, sectionName);
    }

    public FromHereCredentialsIniStream(Clock clock, InputStream inputStream, String sectionName) {
        super(clock);
        Objects.requireNonNull(inputStream, "inputStream is required");
        this.clock = clock;
        this.delegate = FromHereCredentialsIniStream.getClientCredentialsProvider(clock, inputStream, sectionName);
    }

    protected ClientAuthorizationRequestProvider getDelegate() {
        return this.delegate;
    }

    protected static ClientAuthorizationRequestProvider getClientCredentialsProvider(InputStream inputStream, String sectionName) {
        return FromHereCredentialsIniStream.getClientCredentialsProvider(new SettableSystemClock(), inputStream, sectionName);
    }

    protected static ClientAuthorizationRequestProvider getClientCredentialsProvider(Clock clock, InputStream inputStream, String sectionName) {
        try {
            Properties properties = FromHereCredentialsIniStream.getPropertiesFromIni(inputStream, sectionName);
            return FromSystemProperties.getClientCredentialsProviderWithDefaultTokenEndpointUrl(clock, properties);
        }
        catch (IOException e) {
            throw new RequestProviderException("trouble FromFile " + e, e);
        }
    }

    static Properties getPropertiesFromIni(InputStream inputStream, String sectionName) throws IOException {
        Ini ini = new Ini();
        try (InputStreamReader reader = new InputStreamReader(inputStream, OAuthConstants.UTF_8_CHARSET);){
            ini.load((Reader)reader);
            Profile.Section section = (Profile.Section)ini.get((Object)sectionName);
            Properties properties = new Properties();
            properties.put("here.token.endpoint.url", section.get((Object)"here.token.endpoint.url"));
            properties.put("here.access.key.id", section.get((Object)"here.access.key.id"));
            properties.put("here.access.key.secret", section.get((Object)"here.access.key.secret"));
            String scope = (String)section.get((Object)"here.token.scope");
            if (null != scope) {
                properties.put("here.token.scope", scope);
            }
            Properties properties2 = properties;
            return properties2;
        }
    }

    @Override
    public String getTokenEndpointUrl() {
        return this.getDelegate().getTokenEndpointUrl();
    }

    @Override
    public HttpProvider.HttpRequestAuthorizer getClientAuthorizer() {
        return this.getDelegate().getClientAuthorizer();
    }

    @Override
    public HttpConstants.HttpMethods getHttpMethod() {
        return HttpConstants.HttpMethods.POST;
    }

    @Override
    public String getScope() {
        return this.getDelegate().getScope();
    }
}

