/*
 * Decompiled with CFR 0.152.
 */
package com.here.account.oauth2.retry;

import com.here.account.oauth2.retry.RetryContext;
import com.here.account.oauth2.retry.RetryPolicy;
import java.net.SocketTimeoutException;
import java.util.concurrent.ThreadLocalRandom;

public class Socket5xxExponentialRandomBackoffPolicy
implements RetryPolicy {
    public static final int DEFAULT_MAX_NO_RETRIES = 3;
    public static final int DEFAULT_RETRY_INTERVAL_MILLIS = 1000;
    private final int maxNumberOfRetries;
    private final int retryIntervalMillis;

    public Socket5xxExponentialRandomBackoffPolicy() {
        this.maxNumberOfRetries = 3;
        this.retryIntervalMillis = 1000;
    }

    public Socket5xxExponentialRandomBackoffPolicy(int maxNumberOfRetries, int retryIntervalMillis) {
        this.maxNumberOfRetries = maxNumberOfRetries;
        this.retryIntervalMillis = retryIntervalMillis;
    }

    @Override
    public boolean shouldRetry(RetryContext retryContext) {
        return retryContext.getRetryCount() < this.maxNumberOfRetries && (retryContext.getLastException() instanceof SocketTimeoutException || retryContext.getLastRetryResponse() != null && retryContext.getLastRetryResponse().getStatusCode() >= 500) || null != retryContext.getLastException() && retryContext.getLastException().getCause() instanceof SocketTimeoutException;
    }

    @Override
    public int getNextRetryIntervalMillis(RetryContext retryContext) {
        int factor = 1 << retryContext.getRetryCount();
        return this.retryIntervalMillis * ThreadLocalRandom.current().nextInt(factor);
    }
}

