/*
 * Decompiled with CFR 0.152.
 */
package com.here.account.auth.provider;

import com.here.account.auth.provider.ClientCredentialsGrantRequestProvider;
import com.here.account.auth.provider.FromSystemProperties;
import com.here.account.http.HttpConstants;
import com.here.account.http.HttpProvider;
import com.here.account.oauth2.ClientAuthorizationRequestProvider;
import com.here.account.oauth2.ClientCredentialsProvider;
import com.here.account.util.Clock;
import java.util.Properties;

public class FromProperties
extends ClientCredentialsGrantRequestProvider
implements ClientAuthorizationRequestProvider {
    private final Properties properties;

    public FromProperties(Clock clock, String tokenEndpointUrl, String accessKeyId, String accessKeySecret) {
        this(clock, tokenEndpointUrl, accessKeyId, accessKeySecret, null);
    }

    public FromProperties(Clock clock, String tokenEndpointUrl, String accessKeyId, String accessKeySecret, String scope) {
        this(clock, FromProperties.getProperties(tokenEndpointUrl, accessKeyId, accessKeySecret, scope));
    }

    static Properties getProperties(String tokenEndpointUrl, String accessKeyId, String accessKeySecret) {
        return FromProperties.getProperties(tokenEndpointUrl, accessKeyId, accessKeySecret, null);
    }

    static Properties getProperties(String tokenEndpointUrl, String accessKeyId, String accessKeySecret, String scope) {
        Properties properties = new Properties();
        properties.put("here.token.endpoint.url", tokenEndpointUrl);
        properties.put("here.access.key.id", accessKeyId);
        properties.put("here.access.key.secret", accessKeySecret);
        if (null != scope) {
            properties.put("here.token.scope", scope);
        }
        return properties;
    }

    public FromProperties(Clock clock, Properties properties) {
        super(clock);
        this.properties = properties;
    }

    protected ClientCredentialsProvider getDelegate() {
        return FromSystemProperties.getClientCredentialsProviderWithDefaultTokenEndpointUrl(this.getClock(), this.properties);
    }

    @Override
    public String getTokenEndpointUrl() {
        return this.getDelegate().getTokenEndpointUrl();
    }

    @Override
    public HttpProvider.HttpRequestAuthorizer getClientAuthorizer() {
        return this.getDelegate().getClientAuthorizer();
    }

    @Override
    public HttpConstants.HttpMethods getHttpMethod() {
        return HttpConstants.HttpMethods.POST;
    }

    @Override
    public String getScope() {
        return this.getDelegate().getScope();
    }
}

