/*
 * Decompiled with CFR 0.152.
 */
package com.here.account.auth.provider;

import com.here.account.auth.provider.FromDefaultHereCredentialsPropertiesFile;
import com.here.account.auth.provider.FromHereCredentialsIniFile;
import com.here.account.auth.provider.FromRunAsIdFileProvider;
import com.here.account.auth.provider.FromSystemProperties;
import com.here.account.auth.provider.RequestProviderException;
import com.here.account.http.HttpConstants;
import com.here.account.http.HttpProvider;
import com.here.account.oauth2.AccessTokenRequest;
import com.here.account.oauth2.ClientAuthorizationRequestProvider;
import com.here.account.oauth2.ClientCredentialsProvider;
import com.here.account.util.Clock;
import com.here.account.util.SettableSystemClock;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class ClientAuthorizationProviderChain
implements ClientAuthorizationRequestProvider {
    private static final Logger LOG = Logger.getLogger(ClientAuthorizationProviderChain.class.getName());
    private ClientAuthorizationRequestProvider mostRecentProvider = null;
    private List<ClientAuthorizationRequestProvider> clientAuthorizationProviders;
    @Deprecated
    public static ClientAuthorizationProviderChain DEFAULT_CLIENT_CREDENTIALS_PROVIDER_CHAIN = ClientAuthorizationProviderChain.getNewDefaultClientCredentialsProviderChain(new SettableSystemClock());

    public ClientAuthorizationProviderChain(ClientAuthorizationRequestProvider ... clientAuthorizationProviders) {
        this.clientAuthorizationProviders = new ArrayList<ClientAuthorizationRequestProvider>();
        for (ClientAuthorizationRequestProvider clientAuthorizationProvider : clientAuthorizationProviders) {
            this.clientAuthorizationProviders.add(clientAuthorizationProvider);
        }
    }

    public ClientAuthorizationProviderChain(List<ClientCredentialsProvider> clientAuthorizationProviders) {
        this.clientAuthorizationProviders = new ArrayList<ClientCredentialsProvider>(clientAuthorizationProviders);
    }

    public static ClientAuthorizationProviderChain getNewDefaultClientCredentialsProviderChain(Clock clock) {
        FromSystemProperties systemProvider = new FromSystemProperties(clock);
        FromHereCredentialsIniFile iniFileProvider = new FromHereCredentialsIniFile(clock);
        FromDefaultHereCredentialsPropertiesFile propertiesFileProvider = new FromDefaultHereCredentialsPropertiesFile(clock);
        FromRunAsIdFileProvider runAsIdFileProvider = new FromRunAsIdFileProvider(clock);
        return new ClientAuthorizationProviderChain(systemProvider, iniFileProvider, propertiesFileProvider, runAsIdFileProvider);
    }

    protected ClientAuthorizationRequestProvider getClientCredentialsProvider() {
        if (this.mostRecentProvider != null) {
            return this.mostRecentProvider;
        }
        for (ClientAuthorizationRequestProvider credentials : this.clientAuthorizationProviders) {
            try {
                if (null == credentials.getTokenEndpointUrl() || credentials.getTokenEndpointUrl() == "" || null == credentials.getClientAuthorizer()) continue;
                LOG.info("Loading credentials from " + credentials.toString());
                this.mostRecentProvider = credentials;
                return credentials;
            }
            catch (Exception e) {
                LOG.warning("Unable to load credentials from " + credentials.toString() + ": " + e.getMessage());
            }
        }
        throw new RequestProviderException("Unable to load credentials from chain");
    }

    @Override
    public String getTokenEndpointUrl() {
        return this.getClientCredentialsProvider().getTokenEndpointUrl();
    }

    @Override
    public HttpProvider.HttpRequestAuthorizer getClientAuthorizer() {
        return this.getClientCredentialsProvider().getClientAuthorizer();
    }

    @Override
    public AccessTokenRequest getNewAccessTokenRequest() {
        return this.getClientCredentialsProvider().getNewAccessTokenRequest();
    }

    @Override
    public HttpConstants.HttpMethods getHttpMethod() {
        return this.getClientCredentialsProvider().getHttpMethod();
    }

    @Override
    public Clock getClock() {
        return this.getClientCredentialsProvider().getClock();
    }

    @Override
    public String getScope() {
        return this.getClientCredentialsProvider().getScope();
    }
}

