/*
 * Decompiled with CFR 0.152.
 */
package com.here.account.auth.provider;

import com.here.account.auth.OAuth1ClientCredentialsProvider;
import com.here.account.auth.provider.ClientCredentialsGrantRequestProvider;
import com.here.account.auth.provider.DefaultHereConfigFiles;
import com.here.account.auth.provider.FromSystemProperties;
import com.here.account.auth.provider.RequestProviderException;
import com.here.account.http.HttpConstants;
import com.here.account.http.HttpProvider;
import com.here.account.oauth2.ClientAuthorizationRequestProvider;
import com.here.account.oauth2.ClientCredentialsProvider;
import com.here.account.util.Clock;
import com.here.account.util.SettableSystemClock;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public class FromDefaultHereCredentialsPropertiesFile
extends ClientCredentialsGrantRequestProvider
implements ClientAuthorizationRequestProvider {
    private static final String CREDENTIALS_DOT_PROPERTIES_FILENAME = "credentials.properties";
    private final File file;

    public FromDefaultHereCredentialsPropertiesFile() {
        this(new SettableSystemClock());
    }

    public FromDefaultHereCredentialsPropertiesFile(Clock clock) {
        this(clock, FromDefaultHereCredentialsPropertiesFile.getDefaultHereCredentialsFile());
    }

    public FromDefaultHereCredentialsPropertiesFile(File file) {
        this(new SettableSystemClock(), file);
    }

    public FromDefaultHereCredentialsPropertiesFile(Clock clock, File file) {
        super(clock);
        this.file = file;
    }

    protected ClientCredentialsProvider getClientCredentialsProvider() {
        try {
            Properties properties = OAuth1ClientCredentialsProvider.getPropertiesFromFile(this.file);
            return FromSystemProperties.getClientCredentialsProviderWithDefaultTokenEndpointUrl(this.getClock(), properties);
        }
        catch (IOException e) {
            throw new RequestProviderException("trouble FromFile " + e, e);
        }
    }

    static File getDefaultHereCredentialsFile() {
        return DefaultHereConfigFiles.getDefaultHereConfigFile(CREDENTIALS_DOT_PROPERTIES_FILENAME);
    }

    @Override
    public String getTokenEndpointUrl() {
        return this.getClientCredentialsProvider().getTokenEndpointUrl();
    }

    @Override
    public HttpProvider.HttpRequestAuthorizer getClientAuthorizer() {
        return this.getClientCredentialsProvider().getClientAuthorizer();
    }

    @Override
    public HttpConstants.HttpMethods getHttpMethod() {
        return HttpConstants.HttpMethods.POST;
    }

    @Override
    public String getScope() {
        return this.getClientCredentialsProvider().getScope();
    }
}

