/*
 * Decompiled with CFR 0.152.
 */
package com.here.account.auth.provider;

import com.here.account.auth.OAuth1ClientCredentialsProvider;
import com.here.account.auth.provider.ClientCredentialsGrantRequestProvider;
import com.here.account.http.HttpConstants;
import com.here.account.http.HttpProvider;
import com.here.account.oauth2.ClientAuthorizationRequestProvider;
import com.here.account.oauth2.ClientCredentialsProvider;
import com.here.account.util.Clock;
import com.here.account.util.SettableSystemClock;
import java.util.Properties;

public class FromSystemProperties
extends ClientCredentialsGrantRequestProvider
implements ClientAuthorizationRequestProvider {
    private static final String DEFAULT_TOKEN_ENDPOINT_URL = "https://account.api.here.com/oauth2/token";

    public FromSystemProperties() {
        this(new SettableSystemClock());
    }

    public FromSystemProperties(Clock clock) {
        super(clock);
    }

    protected ClientCredentialsProvider getDelegate() {
        Properties properties = System.getProperties();
        return FromSystemProperties.getClientCredentialsProviderWithDefaultTokenEndpointUrl(this.getClock(), properties);
    }

    @Deprecated
    static ClientCredentialsProvider getClientCredentialsProviderWithDefaultTokenEndpointUrl(Properties properties) {
        return FromSystemProperties.getClientCredentialsProviderWithDefaultTokenEndpointUrl(new SettableSystemClock(), properties);
    }

    static ClientCredentialsProvider getClientCredentialsProviderWithDefaultTokenEndpointUrl(Clock clock, Properties properties) {
        return new OAuth1ClientCredentialsProvider(clock, properties.getProperty("here.token.endpoint.url", DEFAULT_TOKEN_ENDPOINT_URL), properties.getProperty("here.access.key.id"), properties.getProperty("here.access.key.secret"), properties.getProperty("here.token.scope"));
    }

    @Override
    public String getTokenEndpointUrl() {
        return this.getDelegate().getTokenEndpointUrl();
    }

    @Override
    public HttpProvider.HttpRequestAuthorizer getClientAuthorizer() {
        return this.getDelegate().getClientAuthorizer();
    }

    @Override
    public HttpConstants.HttpMethods getHttpMethod() {
        return HttpConstants.HttpMethods.POST;
    }

    @Override
    public String getScope() {
        return this.getDelegate().getScope();
    }
}

