/*
 * Decompiled with CFR 0.152.
 */
package com.here.account.identity.bo;

import com.here.account.oauth2.AccessTokenRequest;
import java.util.List;
import java.util.Map;

public class IdentityTokenRequest
extends AccessTokenRequest {
    public static final String IDENTITY_GRANT_TYPE = "identity";
    private String runAsId;
    private String namespace;
    private String runAsIdName;
    private String podName;
    private String podUid;
    private static final String RUN_AS_ID_FORM = "runAsId";
    private static final String NAMESPACE_FORM = "namespace";
    private static final String RUN_AS_ID_NAME_FORM = "runAsIdName";
    private static final String POD_NAME_FORM = "podName";
    private static final String POD_UID_FORM = "podUid";

    public IdentityTokenRequest() {
        super(IDENTITY_GRANT_TYPE);
    }

    public String getRunAsId() {
        return this.runAsId;
    }

    public IdentityTokenRequest withRunAsId(String runAsId) {
        this.runAsId = runAsId;
        return this;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public IdentityTokenRequest withNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public String getRunAsIdName() {
        return this.runAsIdName;
    }

    public IdentityTokenRequest withRunAsIdName(String runAsIdName) {
        this.runAsIdName = runAsIdName;
        return this;
    }

    public String getPodName() {
        return this.podName;
    }

    public IdentityTokenRequest withPodName(String podName) {
        this.podName = podName;
        return this;
    }

    public String getPodUid() {
        return this.podUid;
    }

    public IdentityTokenRequest withPodUid(String podUid) {
        this.podUid = podUid;
        return this;
    }

    @Override
    public Map<String, List<String>> toFormParams() {
        Map<String, List<String>> formParams = super.toFormParams();
        IdentityTokenRequest.addFormParam(formParams, RUN_AS_ID_FORM, this.getRunAsId());
        IdentityTokenRequest.addFormParam(formParams, NAMESPACE_FORM, this.getNamespace());
        IdentityTokenRequest.addFormParam(formParams, RUN_AS_ID_NAME_FORM, this.getRunAsIdName());
        IdentityTokenRequest.addFormParam(formParams, POD_NAME_FORM, this.getPodName());
        IdentityTokenRequest.addFormParam(formParams, POD_UID_FORM, this.getPodUid());
        return formParams;
    }

    public static IdentityTokenRequest fromFormParams(Map<String, List<String>> formParams) {
        IdentityTokenRequest identityTokenRequest = new IdentityTokenRequest().withRunAsId(IdentityTokenRequest.getSingleFormValue(formParams, RUN_AS_ID_FORM)).withNamespace(IdentityTokenRequest.getSingleFormValue(formParams, NAMESPACE_FORM)).withRunAsIdName(IdentityTokenRequest.getSingleFormValue(formParams, RUN_AS_ID_NAME_FORM)).withPodName(IdentityTokenRequest.getSingleFormValue(formParams, POD_NAME_FORM)).withPodUid(IdentityTokenRequest.getSingleFormValue(formParams, POD_UID_FORM));
        String expiresInString = IdentityTokenRequest.getSingleFormValue(formParams, "expires_in");
        if (null != expiresInString) {
            Long expiresIn = Long.parseLong(expiresInString);
            identityTokenRequest.setExpiresIn(expiresIn);
        }
        identityTokenRequest.setScope(IdentityTokenRequest.getSingleFormValue(formParams, "scope"));
        return identityTokenRequest;
    }

    protected static String getSingleFormValue(Map<String, List<String>> formParams, String formParamKey) {
        List<String> values = formParams.get(formParamKey);
        if (null != values && values.size() > 0) {
            return values.get(0);
        }
        return null;
    }
}

