/*
 * Decompiled with CFR 0.152.
 */
package com.here.account.oauth2;

import com.here.account.olp.OlpHttpMessage;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AccessTokenRequest
implements OlpHttpMessage {
    private static final String EXPIRES_IN_JSON = "expiresIn";
    protected static final String EXPIRES_IN_FORM = "expires_in";
    protected static final String GRANT_TYPE_JSON = "grantType";
    protected static final String GRANT_TYPE_FORM = "grant_type";
    protected static final String SCOPE_JSON = "scope";
    protected static final String SCOPE_FORM = "scope";
    private final String grantType;
    private Long expiresIn;
    private String scope;
    private transient Map<String, String> additionalHeaders = null;
    private transient String correlationId = null;

    protected AccessTokenRequest(String grantType) {
        this.grantType = grantType;
    }

    public String getGrantType() {
        return this.grantType;
    }

    public AccessTokenRequest setExpiresIn(Long expiresIn) {
        this.expiresIn = expiresIn;
        return this;
    }

    public Long getExpiresIn() {
        return this.expiresIn;
    }

    public String getScope() {
        return this.scope;
    }

    public AccessTokenRequest setScope(String scope) {
        this.scope = scope;
        return this;
    }

    public Map<String, String> getAdditionalHeaders() {
        return this.additionalHeaders;
    }

    public AccessTokenRequest setAdditionalHeaders(Map<String, String> additionalHeaders) {
        this.additionalHeaders = additionalHeaders;
        return this;
    }

    @Override
    public String getCorrelationId() {
        return this.correlationId;
    }

    @Override
    public AccessTokenRequest setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
        return this;
    }

    @Deprecated
    public String toJson() {
        return "{\"grantType\":\"" + this.getGrantType() + "\"" + (null != this.expiresIn ? ",\"expiresIn\":" + this.expiresIn : "") + ",\"" + "scope" + "\":\"" + this.getScope() + "\"}";
    }

    public Map<String, List<String>> toFormParams() {
        HashMap<String, List<String>> formParams = new HashMap<String, List<String>>();
        AccessTokenRequest.addFormParam(formParams, GRANT_TYPE_FORM, this.getGrantType());
        AccessTokenRequest.addFormParam(formParams, EXPIRES_IN_FORM, this.getExpiresIn());
        AccessTokenRequest.addFormParam(formParams, "scope", this.getScope());
        return formParams;
    }

    protected static final void addFormParam(Map<String, List<String>> formParams, String name, Object value) {
        if (null != formParams && null != name && null != value) {
            formParams.put(name, Collections.singletonList(value.toString()));
        }
    }
}

