/*
 * Decompiled with CFR 0.152.
 */
package com.here.platform.artifact.maven.wagon;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.here.account.auth.OAuth1ClientCredentialsProvider;
import com.here.account.http.HttpProvider;
import com.here.account.http.apache.ApacheHttpClientProvider;
import com.here.account.oauth2.AccessTokenRequest;
import com.here.account.oauth2.ClientAuthorizationRequestProvider;
import com.here.account.oauth2.ClientCredentialsGrantRequest;
import com.here.account.oauth2.HereAccount;
import com.here.account.oauth2.TokenEndpoint;
import com.here.platform.artifact.maven.wagon.Artifact;
import com.here.platform.artifact.maven.wagon.HereAuthenticationException;
import com.here.platform.artifact.maven.wagon.InvalidPathException;
import com.here.platform.artifact.maven.wagon.XRateLimitServiceUnavailableRetryStrategy;
import com.here.platform.artifact.maven.wagon.model.RegisterRequest;
import com.here.platform.artifact.maven.wagon.model.RegisterResponse;
import com.here.platform.artifact.maven.wagon.model.ServiceExceptionResponse;
import com.here.platform.artifact.maven.wagon.resolver.ArtifactServiceUrlResolverChain;
import com.here.platform.artifact.maven.wagon.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.execchain.ClientExecChain;
import org.apache.http.impl.execchain.ServiceUnavailableRetryExec;
import org.apache.http.util.EntityUtils;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.repository.Repository;
import org.apache.maven.wagon.resource.Resource;
import org.apache.maven.wagon.shared.http.AbstractHttpClientWagon;
import org.apache.maven.wagon.shared.http.EncodingUtil;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=Wagon.class)
public class ArtifactWagon
extends AbstractHttpClientWagon {
    private static final int OAUTH_REQUEST_TIMEOUT_IN_MS = 20000;
    private static final int OAUTH_CONNECTION_TIMEOUT_IN_MS = 20000;
    private static final String AUTHORIZATION_FORBIDDEN_ERROR_MESSAGE = "The resource may already exist in the system but your credentials may not grant modification privileges to it";
    private static final String FILE_PUT_ERROR_MESSAGE = "Failed to put the %s artifact file";
    private static final Logger LOG = LoggerFactory.getLogger(ArtifactWagon.class);
    private static final String REGISTER_PREFIX = "register";
    private static final String HERE_CREDENTIALS_PROPERTY = "hereCredentialsFile";
    private static final String HERE_CREDENTIALS_STRING_ENV = "HERE_CREDENTIALS_STRING";
    private static final String HERE_CREDENTIALS_ENV = "HERE_CREDENTIALS_FILE";
    private static final String HERE_CREDENTIALS_PATH = ".here/credentials.properties";
    private static final String HERE_ENDPOINT_URL_KEY = "here.token.endpoint.url";
    private static final String HERE_ACCESS_SECRET_KEY = "here.access.key.secret";
    private static final String HERE_ACCESS_ID_KEY = "here.access.key.id";
    private static final String HERE_USER_ID_KEY = "here.user.id";
    private static final String[][] PROTOCOL_MAP = new String[][]{{"here+http://", "http://"}, {"here+https://", "https://"}};
    private static final String ARTIFACT_SERVICE_URL_PLACEHOLDER_PROTOCOL = "here+artifact-service";
    private final Object lock = new Object();
    private final ObjectMapper objectMapper;
    private final Properties hereProperties = this.loadHereProperties();
    private String authorization;

    public ArtifactWagon() throws IllegalAccessException {
        this.objectMapper = new ObjectMapper();
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        this.setRetryStrategy();
    }

    String getDefaultArtifactServiceUrl() {
        ArtifactServiceUrlResolverChain artifactServiceUrlResolverChain = new ArtifactServiceUrlResolverChain(this::createProxyAwareHttpClient, this.objectMapper);
        String hereTokenEndpointUrl = this.hereProperties.getProperty(HERE_ENDPOINT_URL_KEY);
        String artifactServiceUrl = artifactServiceUrlResolverChain.resolveArtifactServiceUrl(hereTokenEndpointUrl);
        if (StringUtils.isEmpty(artifactServiceUrl)) {
            throw new RuntimeException("Unable to resolve Artifact Service URL");
        }
        return artifactServiceUrl;
    }

    private CloseableHttpClient createProxyAwareHttpClient() {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().addInterceptorFirst((request, context) -> {
            if (request instanceof HttpUriRequest) {
                this.setHeaders((HttpUriRequest)request);
            }
        });
        ProxyInfo proxyInfo = this.getProxyInfo();
        if (proxyInfo != null) {
            String proxyHost = proxyInfo.getHost();
            int proxyport = proxyInfo.getPort();
            BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
            basicCredentialsProvider.setCredentials(new AuthScope(proxyHost, proxyport), (Credentials)new UsernamePasswordCredentials(proxyInfo.getUserName(), proxyInfo.getPassword()));
            httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)basicCredentialsProvider).setProxy(new HttpHost(proxyHost, proxyport));
        }
        return httpClientBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHeaders(HttpUriRequest method) {
        Object object = this.lock;
        synchronized (object) {
            if (this.authorization == null) {
                Properties properties = this.hereProperties;
                if (this.getAuthenticationInfo() != null) {
                    properties = new Properties();
                    properties.putAll((Map<?, ?>)this.hereProperties);
                    if (!StringUtils.isEmpty(this.getAuthenticationInfo().getUserName())) {
                        properties.setProperty(HERE_ACCESS_ID_KEY, this.getAuthenticationInfo().getUserName());
                    }
                    if (!StringUtils.isEmpty(this.getAuthenticationInfo().getPassword())) {
                        properties.setProperty(HERE_ACCESS_SECRET_KEY, this.getAuthenticationInfo().getPassword());
                    }
                }
                this.authorization = this.mintAuthorizationToken(properties);
                LOG.trace("Obtained bearer token: {}", (Object)this.authorization);
            }
        }
        Properties properties = super.getHttpHeaders();
        if (properties == null) {
            properties = new Properties();
        }
        properties.setProperty("Authorization", String.format("Bearer %s", this.authorization));
        this.setHttpHeaders(properties);
        super.setHeaders(method);
    }

    public String getURL(Repository repository) {
        return this.resolveRepositoryUrl(repository.getUrl());
    }

    private String resolveRepositoryUrl(String url) {
        String resolvedUrl = url;
        if (url.startsWith(ARTIFACT_SERVICE_URL_PLACEHOLDER_PROTOCOL)) {
            resolvedUrl = this.getDefaultArtifactServiceUrl();
        } else {
            for (String[] entry : PROTOCOL_MAP) {
                String protocol = entry[0];
                if (!url.startsWith(protocol)) continue;
                resolvedUrl = entry[1] + url.substring(protocol.length());
            }
        }
        return resolvedUrl;
    }

    protected ProxyInfo getProxyInfo(String protocol, String host) {
        ProxyInfo proxyInfo = super.getProxyInfo(protocol, host);
        if (proxyInfo == null && !protocol.startsWith("here+")) {
            proxyInfo = Optional.ofNullable(super.getProxyInfo("here+" + protocol, host)).orElseGet(() -> super.getProxyInfo(ARTIFACT_SERVICE_URL_PLACEHOLDER_PROTOCOL, host));
        }
        return proxyInfo;
    }

    protected InputStream getInputStream(Resource resource) throws TransferFailedException, ResourceDoesNotExistException {
        String path = this.verifyAndRewrite(resource.getName());
        resource.setName(path);
        try {
            return super.getInputStream(resource);
        }
        catch (AuthorizationException exp) {
            throw new ResourceDoesNotExistException("Authorization error using path: " + resource.getName(), (Throwable)exp);
        }
    }

    public void put(File source, String resourceName) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        resourceName = this.registerAndRewrite(resourceName);
        try {
            super.put(source, resourceName);
        }
        catch (AuthorizationException e) {
            throw new AuthorizationException(AUTHORIZATION_FORBIDDEN_ERROR_MESSAGE, (Throwable)e);
        }
        catch (RuntimeException re) {
            throw new TransferFailedException(String.format(FILE_PUT_ERROR_MESSAGE, resourceName), (Throwable)re);
        }
    }

    protected CloseableHttpResponse execute(HttpUriRequest httpMethod) throws HttpException, IOException {
        CloseableHttpResponse httpResponse = super.execute(httpMethod);
        int status = httpResponse.getStatusLine().getStatusCode();
        if (status == 422) {
            String message = "";
            String content = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
            if (!content.isEmpty()) {
                ServiceExceptionResponse exceptionResponse = (ServiceExceptionResponse)this.objectMapper.readValue(content, ServiceExceptionResponse.class);
                message = exceptionResponse.getMessage();
            }
            throw new RuntimeException(httpResponse.getStatusLine() + " " + message);
        }
        return httpResponse;
    }

    public void putFromStream(InputStream stream, String destination, long contentLength, long lastModified) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        destination = this.registerAndRewrite(destination);
        try {
            super.putFromStream(stream, destination, contentLength, lastModified);
        }
        catch (AuthorizationException e) {
            throw new AuthorizationException(AUTHORIZATION_FORBIDDEN_ERROR_MESSAGE, (Throwable)e);
        }
    }

    private String registerAndRewrite(String destination) throws TransferFailedException {
        try {
            Artifact artifact = this.toArtifact(destination);
            RegisterResponse registerResponse = this.registerArtifact(artifact);
            destination = this.buildPath(registerResponse.getGroupHrnPrefix(), artifact);
            LOG.trace("Rewrote path for put: {}", (Object)destination);
        }
        catch (InvalidPathException exp) {
            LOG.warn(String.format("Invalid path passed into wagon provider: %s", destination), (Throwable)exp);
        }
        return destination;
    }

    private String verifyAndRewrite(String destination) throws TransferFailedException, ResourceDoesNotExistException {
        try {
            Artifact artifact = this.toArtifact(destination);
            RegisterResponse registerResponse = this.registerExists(artifact);
            destination = this.buildPath(registerResponse.getGroupHrnPrefix(), artifact);
            LOG.trace("Rewrote path for put: {}", (Object)destination);
        }
        catch (InvalidPathException exp) {
            LOG.warn(String.format("Invalid path passed into wagon provider: %s", destination), (Throwable)exp);
            throw new ResourceDoesNotExistException(destination);
        }
        return destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegisterResponse registerArtifact(Artifact artifact) throws TransferFailedException {
        String registerPath = String.format("%s/%s/%s", REGISTER_PREFIX, artifact.getGroupId(), artifact.getArtifactId());
        String url = EncodingUtil.encodeURLToString((String)this.getURL(this.getRepository()), (String)registerPath);
        HttpPut httpPut = new HttpPut(url);
        httpPut.addHeader("Content-Type", "application/json");
        RegisterRequest request = new RegisterRequest(this.hereProperties.getProperty(HERE_USER_ID_KEY));
        httpPut.setEntity((HttpEntity)new ByteArrayEntity(this.objectMapper.writeValueAsBytes((Object)request)));
        CloseableHttpResponse httpResponse = this.execute((HttpUriRequest)httpPut);
        HttpEntity httpEntity = httpResponse.getEntity();
        try {
            int status = httpResponse.getStatusLine().getStatusCode();
            if (status != 200 && status != 201) {
                String message = "";
                String content = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
                if (!content.isEmpty()) {
                    ServiceExceptionResponse exceptionResponse = (ServiceExceptionResponse)this.objectMapper.readValue(content, ServiceExceptionResponse.class);
                    message = exceptionResponse.getMessage();
                }
                throw new TransferFailedException(String.format("Unable to register group %s and artifact %s: %s %s", artifact.getGroupId(), artifact.getArtifactId(), httpResponse.getStatusLine(), message));
            }
            InputStream content = httpEntity.getContent();
            RegisterResponse registerResponse = (RegisterResponse)this.objectMapper.readValue(content, RegisterResponse.class);
            this.consumeQuietly(httpResponse);
            return registerResponse;
        }
        catch (Throwable throwable) {
            try {
                this.consumeQuietly(httpResponse);
                throw throwable;
            }
            catch (TransferFailedException exp) {
                LOG.error("Error during registerArtifact using path '{}': {}", (Object)registerPath, (Object)exp.getMessage());
                throw exp;
            }
            catch (Exception exp) {
                String msg = String.format("Error during registerArtifact using path '%s': %s", registerPath, exp.getMessage());
                throw new TransferFailedException(msg, (Throwable)exp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegisterResponse registerExists(Artifact artifact) throws ResourceDoesNotExistException, TransferFailedException {
        String registerPath = String.format("%s/%s/%s", REGISTER_PREFIX, artifact.getGroupId(), artifact.getArtifactId());
        String url = EncodingUtil.encodeURLToString((String)this.getURL(this.getRepository()), (String)registerPath);
        HttpGet httpGet = new HttpGet(url);
        CloseableHttpResponse httpResponse = this.execute((HttpUriRequest)httpGet);
        try {
            int status = httpResponse.getStatusLine().getStatusCode();
            if (status != 200) {
                throw new ResourceDoesNotExistException(registerPath);
            }
            InputStream content = httpResponse.getEntity().getContent();
            RegisterResponse registerResponse = (RegisterResponse)this.objectMapper.readValue(content, RegisterResponse.class);
            this.consumeQuietly(httpResponse);
            return registerResponse;
        }
        catch (Throwable throwable) {
            try {
                this.consumeQuietly(httpResponse);
                throw throwable;
            }
            catch (IOException | HttpException exp) {
                String msg = String.format("Error during registerExists using path '%s': %s", registerPath, exp.getMessage());
                throw new TransferFailedException(msg, exp);
            }
        }
    }

    private Artifact toArtifact(String url) {
        String[] parts = url.split("/");
        if (parts.length != 4) {
            throw new InvalidPathException(url);
        }
        return new Artifact(parts[0], parts[1], parts[2], parts[3]);
    }

    private String buildPath(String groupHrnPrefix, Artifact artifact) {
        String version = StringUtils.defaultIfEmpty(artifact.getVersion(), "NONE");
        return String.format("%s:%s:%s/%s", groupHrnPrefix, artifact.getArtifactId(), version, artifact.getFile());
    }

    private String mintAuthorizationToken(Properties properties) {
        LOG.trace("Attempting to authenticate with HERE Account");
        try {
            String endpointUrl = properties.getProperty(HERE_ENDPOINT_URL_KEY);
            if (endpointUrl == null) {
                throw new IllegalArgumentException(String.format("No %s property specified", HERE_ENDPOINT_URL_KEY));
            }
            OAuth1ClientCredentialsProvider.FromProperties credentialsProvider = new OAuth1ClientCredentialsProvider.FromProperties(properties);
            HttpProvider httpProvider = this.createHttpProvider(endpointUrl);
            TokenEndpoint tokenEndpoint = HereAccount.getTokenEndpoint((HttpProvider)httpProvider, (ClientAuthorizationRequestProvider)credentialsProvider);
            return tokenEndpoint.requestToken((AccessTokenRequest)new ClientCredentialsGrantRequest()).getAccessToken();
        }
        catch (Exception exp) {
            throw new HereAuthenticationException("Error authenticating HERE credentials", exp);
        }
    }

    protected Properties loadHereProperties() {
        Properties properties = new Properties();
        File file = ArtifactWagon.resolveFile();
        if (file != null) {
            this.loadCredentialsFromFile(properties, file);
        }
        String credentialsString = System.getenv(HERE_CREDENTIALS_STRING_ENV);
        if (properties.isEmpty() && !StringUtils.isEmpty(credentialsString)) {
            this.loadCredentialsFromString(properties, credentialsString);
        } else {
            this.loadCredentialsFromFile(properties, new File(System.getProperty("user.home"), HERE_CREDENTIALS_PATH));
        }
        return properties;
    }

    private void loadCredentialsFromString(Properties properties, String credentialsString) {
        LOG.debug("Attempting to create credentials from environment variable");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(credentialsString.getBytes());
        try {
            properties.load(byteArrayInputStream);
        }
        catch (IOException exp) {
            LOG.warn("Unable to create client credentials from environment variable {}", (Object)HERE_CREDENTIALS_STRING_ENV, (Object)exp);
        }
    }

    private void loadCredentialsFromFile(Properties properties, File file) {
        LOG.debug("Using here credentials file: {}", (Object)file.getAbsolutePath());
        if (file.exists() && file.canRead()) {
            LOG.debug("Attempting to read credentials file at: {}", (Object)file.getAbsolutePath());
            try (FileInputStream in = new FileInputStream(file);){
                properties.load(in);
            }
            catch (IOException exp) {
                LOG.warn("Unable to read client credentials at {}", (Object)file.getAbsolutePath(), (Object)exp);
            }
        } else {
            LOG.warn("Unable to read configured file: {}", (Object)file.getAbsolutePath());
        }
    }

    private static File resolveFile() {
        File file = null;
        String systemPropertyFile = System.getProperty(HERE_CREDENTIALS_PROPERTY);
        if (!StringUtils.isEmpty(systemPropertyFile)) {
            LOG.debug("Found property file value at System Property {}: {}", (Object)HERE_CREDENTIALS_PROPERTY, (Object)systemPropertyFile);
        } else {
            systemPropertyFile = System.getenv(HERE_CREDENTIALS_ENV);
            if (!StringUtils.isEmpty(systemPropertyFile)) {
                LOG.debug("Found property file at Environment Property {}: {}", (Object)HERE_CREDENTIALS_ENV, (Object)systemPropertyFile);
            }
        }
        if (!StringUtils.isEmpty(systemPropertyFile)) {
            file = new File(systemPropertyFile);
        }
        return file;
    }

    private HttpProvider createHttpProvider(String endpointUrl) {
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom().setConnectTimeout(20000).setConnectionRequestTimeout(20000);
        BasicCredentialsProvider credentialsProvider = null;
        URI endpointUri = URI.create(endpointUrl);
        ProxyInfo proxyInfo = this.getProxyInfo(endpointUri.getScheme(), endpointUri.getHost());
        if (proxyInfo != null) {
            LOG.debug("Found proxy information: {}:{}", (Object)proxyInfo.getHost(), (Object)proxyInfo.getPort());
            requestConfigBuilder.setProxy(new HttpHost(proxyInfo.getHost(), proxyInfo.getPort()));
            if (!StringUtils.isEmpty(proxyInfo.getUserName())) {
                LOG.debug("Found proxy security: {}", (Object)proxyInfo.getUserName());
                credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(new AuthScope(proxyInfo.getHost(), proxyInfo.getPort()), (Credentials)new UsernamePasswordCredentials(proxyInfo.getUserName(), proxyInfo.getPassword()));
            }
        }
        HttpClientBuilder clientBuilder = HttpClientBuilder.create().setDefaultRequestConfig(requestConfigBuilder.build());
        if (credentialsProvider != null) {
            clientBuilder.setDefaultCredentialsProvider(credentialsProvider);
        }
        return ApacheHttpClientProvider.builder().setHttpClient(clientBuilder.build()).setDoCloseHttpClient(true).build();
    }

    private void consumeQuietly(CloseableHttpResponse httpResponse) {
        if (httpResponse != null) {
            EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
            try {
                httpResponse.close();
            }
            catch (IOException exp) {
                LOG.trace("Error during consuming response", (Throwable)exp);
            }
        }
    }

    private void setRetryStrategy() throws IllegalAccessException {
        CloseableHttpClient httpClient = ArtifactWagon.getHttpClient();
        ClientExecChain clientExecChain = (ClientExecChain)ReflectionUtils.getValueIncludingSuperclasses((String)"execChain", (Object)httpClient);
        ServiceUnavailableRetryExec serviceUnavailableRetryExec = new ServiceUnavailableRetryExec(clientExecChain, (ServiceUnavailableRetryStrategy)new XRateLimitServiceUnavailableRetryStrategy());
        ReflectionUtils.setVariableValueInObject((Object)httpClient, (String)"execChain", (Object)serviceUnavailableRetryExec);
    }
}

