/*
 * Decompiled with CFR 0.152.
 */
package com.here.platform.artifact.maven.wagon;

import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.protocol.HttpContext;
import org.apache.maven.wagon.shared.http.StandardServiceUnavailableRetryStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XRateLimitServiceUnavailableRetryStrategy
extends StandardServiceUnavailableRetryStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(XRateLimitServiceUnavailableRetryStrategy.class);
    public static final String X_RATE_LIMIT_RESET_HEADER = "X-RateLimit-Reset";
    public static final String RETRY_AFTER_HEADER = "Retry-After";
    private static final int MAX_RETRIES = 5;
    private static final int DEFAULT_RETRY_INTERVAL_MS = 5000;
    private static final Pattern DIGIT_PATTERN = Pattern.compile("\\d+");
    private final ThreadLocal<HttpResponse> currentResponse = new ThreadLocal();

    public XRateLimitServiceUnavailableRetryStrategy() {
        super(5, 5000);
    }

    public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
        this.currentResponse.set(response);
        return super.retryRequest(response, executionCount, context);
    }

    public long getRetryInterval() {
        HttpResponse httpResponse = this.currentResponse.get();
        if (httpResponse != null) {
            try {
                Header waitHeader;
                Header header = waitHeader = httpResponse.containsHeader(X_RATE_LIMIT_RESET_HEADER) ? httpResponse.getFirstHeader(X_RATE_LIMIT_RESET_HEADER) : httpResponse.getFirstHeader(RETRY_AFTER_HEADER);
                if (waitHeader != null) {
                    String value = waitHeader.getValue();
                    if (value != null && DIGIT_PATTERN.matcher(value).matches()) {
                        LOG.info("Request is failed with code {}. Retrying in {} seconds", (Object)httpResponse.getStatusLine().getStatusCode(), (Object)value);
                        return Long.parseLong(value) * 1000L;
                    }
                    LOG.warn("Header {} have value {} but numeric value expected", (Object)waitHeader.getName(), (Object)waitHeader.getValue());
                }
            }
            catch (Exception e) {
                LOG.warn("Unexpected exception occurred. Fallback to standard retry logic", (Throwable)e);
            }
        }
        return super.getRetryInterval();
    }
}

