/*
 * Decompiled with CFR 0.152.
 */
package com.here.platform.artifact.maven.wagon.layout;

import com.here.platform.artifact.maven.wagon.util.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=ArtifactRepositoryLayout.class, hint="here")
public class HereArtifactRepositoryLayout
extends DefaultRepositoryLayout {
    private static final char PATH_SEPARATOR = '/';
    private static final char GROUP_SEPARATOR = '.';
    private static final char ARTIFACT_SEPARATOR = '-';
    private static final int PATH_CAPACITY = 128;

    public String getId() {
        return "here";
    }

    public String pathOf(Artifact artifact) {
        ArtifactHandler artifactHandler = artifact.getArtifactHandler();
        StringBuilder path = new StringBuilder(128);
        path.append(artifact.getGroupId()).append('/');
        path.append(artifact.getArtifactId()).append('/');
        path.append(artifact.getBaseVersion()).append('/');
        path.append(artifact.getArtifactId()).append('-').append(artifact.getVersion());
        if (artifact.hasClassifier()) {
            path.append('-').append(artifact.getClassifier());
        }
        if (!StringUtils.isEmpty(artifactHandler.getExtension())) {
            path.append('.').append(artifactHandler.getExtension());
        }
        return path.toString();
    }

    public String pathOfRemoteRepositoryMetadata(ArtifactMetadata metadata) {
        StringBuilder path = new StringBuilder(128);
        path.append(metadata.getGroupId()).append('/');
        if (!metadata.storedInGroupDirectory()) {
            path.append(metadata.getArtifactId()).append('/');
            if (metadata.storedInArtifactVersionDirectory()) {
                path.append(metadata.getBaseVersion()).append('/');
            } else {
                path.append("NONE").append('/');
            }
        }
        path.append(metadata.getRemoteFilename());
        return path.toString();
    }
}

