/*
 * Decompiled with CFR 0.152.
 */
package com.here.platform.artifact.maven.wagon.layout;

import com.here.platform.artifact.maven.wagon.util.StringUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.spi.connector.layout.RepositoryLayout;

public class HereRepositoryLayoutDecorator
implements InvocationHandler {
    private static final char PATH_SEPARATOR = '/';
    private static final char ARTIFACT_SEPARATOR = '-';
    private static final char EXTENSION_SEPARATOR = '.';
    private static final int LOCATION_CAPACITY = 128;
    private static final Method getLocation_artifact_upload_method;
    private static final Method getLocation_metadata_upload_method;
    private final RepositoryLayout delegate;

    public static Object newInstance(RepositoryLayout delegate) {
        return Proxy.newProxyInstance(delegate.getClass().getClassLoader(), new Class[]{RepositoryLayout.class}, (InvocationHandler)new HereRepositoryLayoutDecorator(delegate));
    }

    private HereRepositoryLayoutDecorator(RepositoryLayout delegate) {
        this.delegate = delegate;
    }

    public URI getLocation(Artifact artifact, boolean upload) {
        StringBuilder path = new StringBuilder(128);
        path.append(artifact.getGroupId()).append('/');
        path.append(artifact.getArtifactId()).append('/');
        path.append(artifact.getBaseVersion()).append('/');
        path.append(artifact.getArtifactId()).append('-').append(artifact.getVersion());
        if (!StringUtils.isEmpty(artifact.getClassifier())) {
            path.append('-').append(artifact.getClassifier());
        }
        if (!StringUtils.isEmpty(artifact.getExtension())) {
            path.append('.').append(artifact.getExtension());
        }
        return this.toUri(path.toString());
    }

    public URI getLocation(Metadata metadata, boolean upload) {
        if (metadata.getGroupId().isEmpty() || metadata.getArtifactId().isEmpty()) {
            throw new IllegalArgumentException("Invalid path for HERE layout: " + metadata);
        }
        StringBuilder path = new StringBuilder(128);
        path.append(metadata.getGroupId()).append('/');
        path.append(metadata.getArtifactId()).append('/');
        path.append(StringUtils.defaultIfEmpty(metadata.getVersion(), "NONE")).append('/');
        path.append(metadata.getType());
        return this.toUri(path.toString());
    }

    private URI toUri(String path) {
        try {
            return new URI(null, null, path, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        if (m.equals(getLocation_artifact_upload_method) && args.length == 2) {
            return this.getLocation((Artifact)args[0], (boolean)((Boolean)args[1]));
        }
        if (m.equals(getLocation_metadata_upload_method) && args.length == 2) {
            return this.getLocation((Metadata)args[0], (boolean)((Boolean)args[1]));
        }
        return m.invoke((Object)this.delegate, args);
    }

    static {
        try {
            getLocation_artifact_upload_method = RepositoryLayout.class.getMethod("getLocation", Artifact.class, Boolean.TYPE);
            getLocation_metadata_upload_method = RepositoryLayout.class.getMethod("getLocation", Metadata.class, Boolean.TYPE);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

