/*
 * Decompiled with CFR 0.152.
 */
package com.here.platform.artifact.maven.wagon.resolver;

import com.here.platform.artifact.maven.wagon.resolver.ArtifactServiceUrlResolver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Duration;
import java.time.Instant;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ArtifactServiceUrlFileResolver
implements ArtifactServiceUrlResolver {
    private static final Logger LOG = LoggerFactory.getLogger(ArtifactServiceUrlFileResolver.class);
    private static final String FILE_NAME = "artifact_wagon_url_cache.properties";
    private static final long MAX_FILE_AGE_MINUTES = 5L;

    ArtifactServiceUrlFileResolver() {
    }

    @Override
    public String resolveArtifactServiceUrl(String tokenUrl) {
        try {
            Properties prop = this.loadCachedProperties(this.getCacheFile());
            return prop.getOrDefault((Object)tokenUrl, "").toString();
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Can't resolve Artifact Service URL from file", (Throwable)e);
            } else {
                LOG.warn("Can't resolve Artifact Service URL from file");
            }
            return "";
        }
    }

    @Override
    public void afterUrlResolved(String tokenUrl, String resolvedUrl) {
        block14: {
            try {
                Path cacheFile = this.getCacheFile();
                Properties prop = this.loadCachedProperties(cacheFile);
                try (OutputStream output = Files.newOutputStream(cacheFile, new OpenOption[0]);){
                    prop.put(tokenUrl, resolvedUrl);
                    prop.store(output, "Artifact Service URL cache");
                }
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block14;
                LOG.debug("Failed to update Artifact Service URL in temp file", (Throwable)e);
            }
        }
    }

    private Properties loadCachedProperties(Path path) throws IOException {
        try (InputStream input = Files.newInputStream(path, new OpenOption[0]);){
            Properties prop = new Properties();
            prop.load(input);
            Properties properties = prop;
            return properties;
        }
    }

    private Path getCacheFile() throws IOException {
        Path path = Paths.get(System.getProperty("java.io.tmpdir"), FILE_NAME);
        File file = path.toFile();
        if (!file.createNewFile() && this.isFileOlderThan(path, 5L)) {
            file.delete();
            file.createNewFile();
        }
        return path;
    }

    private boolean isFileOlderThan(Path path, long minutes) throws IOException {
        Instant now;
        Instant fileInstant = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]).creationTime().toInstant();
        Duration difference = Duration.between(fileInstant, now = Instant.now());
        return difference.toMinutes() > minutes;
    }
}

