/*
 * Decompiled with CFR 0.152.
 */
package com.here.platform.artifact.maven.wagon.resolver;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.here.platform.artifact.maven.wagon.resolver.ArtifactServiceUrlFileResolver;
import com.here.platform.artifact.maven.wagon.resolver.ArtifactServiceUrlInMemoryCachedResolver;
import com.here.platform.artifact.maven.wagon.resolver.ArtifactServiceUrlLookupResolver;
import com.here.platform.artifact.maven.wagon.resolver.ArtifactServiceUrlResolver;
import com.here.platform.artifact.maven.wagon.util.StringUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import java.util.function.Supplier;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactServiceUrlResolverChain {
    private static final Logger LOG = LoggerFactory.getLogger(ArtifactServiceUrlResolverChain.class);
    private final List<ArtifactServiceUrlResolver> resolversChain;

    public ArtifactServiceUrlResolverChain(Supplier<CloseableHttpClient> httpClientFactory, ObjectMapper objectMapper) {
        this.resolversChain = Arrays.asList(new ArtifactServiceUrlInMemoryCachedResolver(), new ArtifactServiceUrlFileResolver(), new ArtifactServiceUrlLookupResolver(httpClientFactory, objectMapper));
    }

    public String resolveArtifactServiceUrl(String tokenUrl) {
        String resolvedUrl = "";
        Stack<ArtifactServiceUrlResolver> usedResolvers = new Stack<ArtifactServiceUrlResolver>();
        for (ArtifactServiceUrlResolver artifactServiceUrlResolver : this.resolversChain) {
            LOG.debug("Resolving URL using " + artifactServiceUrlResolver.getClass());
            resolvedUrl = artifactServiceUrlResolver.resolveArtifactServiceUrl(tokenUrl);
            if (!StringUtils.isEmpty(resolvedUrl)) {
                LOG.debug("Resolved URL: " + resolvedUrl);
                break;
            }
            usedResolvers.push(artifactServiceUrlResolver);
        }
        if (!StringUtils.isEmpty(resolvedUrl) && !usedResolvers.isEmpty()) {
            this.populateResolvedUrl(usedResolvers, tokenUrl, resolvedUrl);
        }
        return resolvedUrl;
    }

    private void populateResolvedUrl(Stack<ArtifactServiceUrlResolver> usedResolvers, String tokenUrl, String resolvedUrl) {
        for (ArtifactServiceUrlResolver usedResolver : usedResolvers) {
            usedResolver.afterUrlResolved(tokenUrl, resolvedUrl);
        }
    }
}

