/*
 * Decompiled with CFR 0.152.
 */
package rationals;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import rationals.Acceptor;
import rationals.Builder;
import rationals.Couple;
import rationals.DefaultStateFactory;
import rationals.NoSuchStateException;
import rationals.Rational;
import rationals.State;
import rationals.StateFactory;
import rationals.StateMachine;
import rationals.Transition;
import rationals.converters.toAscii;
import rationals.transformations.TransformationsToolBox;

public class Automaton<T extends Builder<T>>
implements Acceptor,
StateMachine,
Rational,
Cloneable {
    private Object id;
    protected T builder;
    protected Set<Object> alphabet;
    private Set<State> states;
    private Set<State> initials;
    private Set<State> terminals;
    private Map<Key, Set<Transition>> transitions;
    private Map<Key, Set<Transition>> reverse;
    private StateFactory stateFactory = new DefaultStateFactory(this);
    private Map<Object, State> labels = new HashMap<Object, State>();

    @Override
    public Object getId() {
        return this.id == null ? "automaton" : this.id;
    }

    @Override
    public void setId(Object id) {
        this.id = id;
    }

    @Override
    public StateFactory getStateFactory() {
        return this.stateFactory;
    }

    @Override
    public void setStateFactory(StateFactory factory) {
        this.stateFactory = factory;
        factory.setAutomaton(this);
    }

    public static Automaton epsilonAutomaton() {
        Automaton v = new Automaton();
        v.addState(true, true);
        return v;
    }

    public static Automaton labelAutomaton(Object label) {
        Automaton v = new Automaton();
        State start = v.addState(true, false);
        State end = v.addState(false, true);
        try {
            v.addTransition(new Transition(start, label, end));
        }
        catch (NoSuchStateException x) {
            // empty catch block
        }
        return v;
    }

    public static Automaton labelAutomaton(List word) {
        Automaton v = new Automaton();
        State start = null;
        if (word.isEmpty()) {
            v.addState(true, true);
            return v;
        }
        start = v.addState(true, false);
        State end = null;
        try {
            Iterator i = word.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                end = v.addState(false, !i.hasNext());
                v.addTransition(new Transition(start, o, end));
                start = end;
            }
        }
        catch (NoSuchStateException x) {
            // empty catch block
        }
        return v;
    }

    public Automaton() {
        this(null);
    }

    public Automaton(StateFactory sf) {
        this.stateFactory = sf == null ? new DefaultStateFactory(this) : sf;
        this.alphabet = new HashSet<Object>();
        this.states = this.stateFactory.stateSet();
        this.initials = this.stateFactory.stateSet();
        this.terminals = this.stateFactory.stateSet();
        this.transitions = new HashMap<Key, Set<Transition>>();
        this.reverse = new HashMap<Key, Set<Transition>>();
    }

    @Override
    public State addState(boolean initial, boolean terminal) {
        State state = this.stateFactory.create(initial, terminal);
        if (initial) {
            this.initials.add(state);
        }
        if (terminal) {
            this.terminals.add(state);
        }
        this.states.add(state);
        return state;
    }

    @Override
    public Set<Object> alphabet() {
        return this.alphabet;
    }

    @Override
    public Set<State> states() {
        return this.states;
    }

    @Override
    public Set<State> initials() {
        return this.initials;
    }

    @Override
    public Set<State> terminals() {
        return this.terminals;
    }

    protected Set<State> access(Set<State> start, Map<Key, Set<Transition>> map) {
        Set<State> old;
        Set<State> current = start;
        do {
            old = current;
            current = this.stateFactory.stateSet();
            for (State e : old) {
                current.add(e);
                Iterator<Object> j = this.alphabet.iterator();
                while (j.hasNext()) {
                    Iterator<Transition> k = this.find(map, e, j.next()).iterator();
                    while (k.hasNext()) {
                        current.add(k.next().end());
                    }
                }
            }
        } while (current.size() != old.size());
        return current;
    }

    @Override
    public Set<State> accessibleStates() {
        return this.access(this.initials, this.transitions);
    }

    @Override
    public Set<State> accessibleStates(Set<State> states) {
        return this.access(states, this.transitions);
    }

    @Override
    public Set<State> accessibleStates(State state) {
        Set<State> s = this.stateFactory.stateSet();
        s.add(state);
        return this.access(s, this.transitions);
    }

    @Override
    public Set<State> coAccessibleStates(Set<State> states) {
        return this.access(states, this.reverse);
    }

    @Override
    public Set<State> coAccessibleStates() {
        return this.access(this.terminals, this.reverse);
    }

    @Override
    public Set<State> accessibleAndCoAccessibleStates() {
        Set<State> ac = this.accessibleStates();
        ac.retainAll(this.coAccessibleStates());
        return ac;
    }

    protected Set<Transition> find(Map<Key, Set<Transition>> m, State e, Object l) {
        Key n = new Key(e, l);
        if (!m.containsKey(n)) {
            return new HashSet<Transition>();
        }
        return m.get(n);
    }

    protected void add(Map<Key, Set<Transition>> m, Transition t) {
        Set<Object> s;
        Key n = new Key(t.start(), t.label());
        if (!m.containsKey(n)) {
            s = new HashSet();
            m.put(n, s);
        } else {
            s = m.get(n);
        }
        s.add(t);
    }

    @Override
    public Set<Transition> delta() {
        HashSet<Transition> s = new HashSet<Transition>();
        for (Set<Transition> tr : this.transitions.values()) {
            s.addAll(tr);
        }
        return s;
    }

    @Override
    public Set<Transition> delta(State state, Object label) {
        return this.find(this.transitions, state, label);
    }

    @Override
    public Set<Transition> deltaFrom(State from, State to) {
        Set<Transition> t = this.delta(from);
        Iterator<Transition> i = t.iterator();
        while (i.hasNext()) {
            Transition tr = i.next();
            if (to.equals(tr.end())) continue;
            i.remove();
        }
        return t;
    }

    @Override
    public Set<Transition> delta(State state) {
        HashSet<Transition> s = new HashSet<Transition>();
        for (Object lt : this.alphabet) {
            s.addAll(this.delta(state, lt));
        }
        return s;
    }

    @Override
    public Set<Transition> delta(Set<State> s) {
        HashSet<Transition> ds = new HashSet<Transition>();
        for (State st : s) {
            ds.addAll(this.delta(st));
        }
        return ds;
    }

    public Map couples() {
        Iterator<Map.Entry<Key, Set<Transition>>> it = this.transitions.entrySet().iterator();
        HashMap<Couple, HashSet<Transition>> ret = new HashMap<Couple, HashSet<Transition>>();
        while (it.hasNext()) {
            Map.Entry<Key, Set<Transition>> e = it.next();
            State st = e.getKey().s;
            for (Transition tr : e.getValue()) {
                State nd = tr.end();
                Couple cpl = new Couple(st, nd);
                HashSet<Transition> s = (HashSet<Transition>)ret.get(cpl);
                if (s == null) {
                    s = new HashSet<Transition>();
                }
                s.add(tr);
                ret.put(cpl, s);
            }
        }
        return ret;
    }

    @Override
    public Set<Transition> deltaMinusOne(State state, Object label) {
        return this.find(this.reverse, state, label);
    }

    @Override
    public void addTransition(Transition transition) throws NoSuchStateException {
        if (!this.states.contains(transition.start()) || !this.states.contains(transition.end())) {
            throw new NoSuchStateException();
        }
        if (!this.alphabet.contains(transition.label())) {
            this.alphabet.add(transition.label());
        }
        this.add(this.transitions, transition);
        this.add(this.reverse, new Transition(transition.end(), transition.label(), transition.start()));
    }

    public void projectOn(Set alph) {
        Iterator<Map.Entry<Key, Set<Transition>>> trans = this.transitions.entrySet().iterator();
        HashSet<Transition> newtrans = new HashSet<Transition>();
        while (trans.hasNext()) {
            Map.Entry<Key, Set<Transition>> entry = trans.next();
            Key k = entry.getKey();
            Iterator<Transition> tit = entry.getValue().iterator();
            while (tit.hasNext()) {
                Transition tr = tit.next();
                if (alph.contains(k.l)) continue;
                newtrans.add(new Transition(k.s, null, tr.end()));
                tit.remove();
            }
        }
        if (!newtrans.isEmpty()) {
            for (Transition tr : newtrans) {
                this.add(this.transitions, tr);
                this.add(this.reverse, new Transition(tr.end(), tr.label(), tr.start()));
            }
        }
        this.alphabet.retainAll(alph);
    }

    public String toString() {
        return new toAscii().toString(this);
    }

    public Object clone() {
        Automaton<T> b = new Automaton<T>();
        HashMap<State, State> map = new HashMap<State, State>();
        for (State e : this.states) {
            map.put(e, b.addState(e.isInitial(), e.isTerminal()));
        }
        for (Transition t : this.delta()) {
            try {
                b.addTransition(new Transition((State)map.get(t.start()), t.label(), (State)map.get(t.end())));
            }
            catch (NoSuchStateException x) {}
        }
        return b;
    }

    public boolean prefixProjection(List word) {
        Set<State> s = this.stepsProject(word);
        return !s.isEmpty();
    }

    public Set<State> stepsProject(List word) {
        Set<State> s = this.initials();
        for (Object o : word) {
            if (!this.alphabet.contains(o) || !(s = this.step(s, o)).isEmpty()) continue;
            return s;
        }
        return s;
    }

    @Override
    public boolean accept(List<Object> word) {
        Set<State> s = TransformationsToolBox.epsilonClosure(this.steps(word), this);
        s.retainAll(this.terminals());
        return !s.isEmpty();
    }

    public boolean accept(State state, List<Object> word) {
        Set<State> s = this.stateFactory.stateSet();
        s.add(state);
        return !this.steps(s, word).isEmpty();
    }

    @Override
    public Set<State> steps(List<Object> word) {
        Set<State> s = TransformationsToolBox.epsilonClosure(this.initials(), this);
        return this.steps(s, word);
    }

    @Override
    public Set<State> steps(Set<State> s, List<Object> word) {
        for (Object o : word) {
            if (!(s = this.step(s, o)).isEmpty()) continue;
            return s;
        }
        return s;
    }

    @Override
    public Set<State> steps(State st, List<Object> word) {
        Set<State> s = this.stateFactory.stateSet();
        s.add(st);
        for (Object o : word) {
            if (!(s = this.step(s, o)).isEmpty()) continue;
            return s;
        }
        return s;
    }

    @Override
    public List<Set<State>> traceStates(List<Object> word, State start) {
        ArrayList<Set<State>> ret = new ArrayList<Set<State>>();
        Set<State> s = null;
        if (start != null) {
            s = this.stateFactory.stateSet();
            s.add(start);
        } else {
            s = this.initials();
        }
        for (Object o : word) {
            if (!this.alphabet.contains(o)) continue;
            s = this.step(s, o);
            ret.add(s);
            if (!s.isEmpty()) continue;
            return null;
        }
        return ret;
    }

    public int longestPrefixWithProjection(List word) {
        int lret = 0;
        Set<State> s = this.initials();
        for (Object o : word) {
            if (o == null || !this.alphabet.contains(o)) {
                ++lret;
                continue;
            }
            if ((s = this.step(s, o)).isEmpty()) break;
            ++lret;
        }
        return lret;
    }

    @Override
    public Set<State> step(Set<State> s, Object o) {
        Set<State> ns = this.stateFactory.stateSet();
        Set<State> ec = TransformationsToolBox.epsilonClosure(s, this);
        for (State st : ec) {
            for (Transition tr : this.delta(st)) {
                if (tr.label() == null || !tr.label().equals(o)) continue;
                ns.add(tr.end());
            }
        }
        return ns;
    }

    public void updateTransitionWith(Transition tr, Object msg) {
        Object lbl = tr.label();
        this.alphabet.remove(lbl);
        this.alphabet.add(msg);
        Key k = new Key(tr.start(), lbl);
        Set<Transition> s = this.transitions.remove(k);
        if (s != null) {
            this.transitions.put(new Key(tr.start(), msg), s);
        }
        if ((s = this.reverse.remove(k = new Key(tr.end(), lbl))) != null) {
            this.reverse.put(new Key(tr.end(), msg), s);
        }
        tr.setLabel(msg);
    }

    @Override
    public Set<Transition> deltaMinusOne(State st) {
        HashSet<Transition> s = new HashSet<Transition>();
        Iterator<Object> alphit = this.alphabet().iterator();
        while (alphit.hasNext()) {
            s.addAll(this.deltaMinusOne(st, alphit.next()));
        }
        return s;
    }

    public Set enumerate(int ln) {
        HashSet<List<Object>> ret = new HashSet<List<Object>>();
        class EnumState {
            State st;
            List<Object> word;

            public EnumState(State s, List<Object> list) {
                this.st = s;
                this.word = new ArrayList<Object>(list);
            }
        }
        LinkedList<EnumState> ll = new LinkedList<EnumState>();
        ArrayList<Object> cur = new ArrayList<Object>();
        for (State s : this.initials) {
            if (s.isTerminal()) {
                ret.add(new ArrayList());
            }
            ll.add(new EnumState(s, cur));
        }
        do {
            EnumState st = (EnumState)ll.removeFirst();
            Set<Transition> trs = this.delta(st.st);
            List<Object> word = st.word;
            for (Transition tr : trs) {
                word.add(tr.label());
                if (word.size() <= ln) {
                    EnumState en = new EnumState(tr.end(), word);
                    ll.add(en);
                    ret.add(en.word);
                }
                word.remove(word.size() - 1);
            }
        } while (!ll.isEmpty());
        return ret;
    }

    public State state(Object label) {
        State s = this.labels.get(label);
        if (s == null) {
            s = this.stateFactory.create(false, false);
            this.states.add(s);
            this.labels.put(label, s);
        }
        return s;
    }

    public T from(Object o) {
        return this.builder.build(this.state(o), this);
    }

    public void setBuilder(T t) {
        this.builder = t;
    }

    private class Key {
        private State s;
        private Object l;

        protected Key(State s, Object l) {
            this.s = s;
            this.l = l;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            try {
                Key t = (Key)o;
                boolean ret = (this.l == null ? t.l == null : this.l.equals(t.l)) && (this.s == null ? t.s == null : this.s.equals(t.s));
                return ret;
            }
            catch (ClassCastException x) {
                return false;
            }
        }

        public int hashCode() {
            int x = this.s == null ? 0 : this.s.hashCode();
            int y = this.l == null ? 0 : this.l.hashCode();
            return y << 16 | x;
        }
    }
}

