/*
 * Decompiled with CFR 0.152.
 */
package rationals;

import rationals.Automaton;
import rationals.Builder;
import rationals.NoSuchStateException;
import rationals.State;
import rationals.Transition;

public class TransitionBuilder
implements Builder<TransitionBuilder> {
    private State start;
    private Automaton automaton;
    protected Object label;

    public TransitionBuilder(State state, Automaton automaton) {
        this.start = state;
        this.automaton = automaton;
    }

    public TransitionBuilder() {
    }

    @Override
    public TransitionBuilder on(Object label) {
        this.label = label;
        return this;
    }

    @Override
    public TransitionBuilder go(Object o) {
        block2: {
            State s = this.automaton.state(o);
            try {
                this.automaton.addTransition(new Transition(this.start, this.label, s));
            }
            catch (NoSuchStateException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return this;
    }

    @Override
    public TransitionBuilder loop() {
        block2: {
            try {
                this.automaton.addTransition(new Transition(this.start, this.label, this.start));
            }
            catch (NoSuchStateException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return this;
    }

    @Override
    public TransitionBuilder from(Object label) {
        this.start = this.automaton.state(label);
        this.label = null;
        return this;
    }

    @Override
    public TransitionBuilder build(State state, Automaton<TransitionBuilder> auto) {
        this.start = state;
        this.label = null;
        this.automaton = auto;
        return this;
    }
}

