/*
 * Decompiled with CFR 0.152.
 */
package rationals.converters.analyzers;

import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import rationals.converters.ConverterException;
import rationals.converters.analyzers.Lexer;

public class DefaultLexer
implements Lexer {
    private StreamTokenizer tokenizer;
    private boolean end;
    private String image;
    private int value;
    private int current;

    public DefaultLexer(String in) {
        this(new StreamTokenizer(new StringReader(in)));
    }

    public DefaultLexer(Reader rd) {
        this(new StreamTokenizer(rd));
    }

    public DefaultLexer(StreamTokenizer st) {
        this.tokenizer = st;
        this.tokenizer.resetSyntax();
        this.tokenizer.eolIsSignificant(false);
        this.tokenizer.lowerCaseMode(false);
        this.tokenizer.slashSlashComments(true);
        this.tokenizer.quoteChar(34);
        this.tokenizer.wordChars(48, 57);
        this.tokenizer.whitespaceChars(0, 32);
        this.end = false;
    }

    @Override
    public void read() throws ConverterException {
        int tk;
        if (this.end) {
            this.current = 9;
            return;
        }
        try {
            tk = this.tokenizer.nextToken();
        }
        catch (IOException e) {
            throw new ConverterException("Unexpected character");
        }
        if (tk == -1) {
            this.end = true;
            this.value = 0;
            this.image = "";
            this.current = 9;
            return;
        }
        if (tk == -3) {
            this.image = this.tokenizer.sval;
            if (this.image.charAt(0) >= '0' && this.image.charAt(0) <= '9') {
                try {
                    this.value = Integer.parseInt(this.tokenizer.sval);
                    this.image = "";
                    this.current = this.value == 0 ? 3 : (this.value == 1 ? 2 : 1);
                    return;
                }
                catch (Exception e) {
                    this.current = 10;
                    return;
                }
            }
            this.value = 0;
            this.current = 0;
            return;
        }
        this.image = "";
        this.value = 0;
        switch (tk) {
            case 43: {
                this.current = 5;
                return;
            }
            case 42: {
                this.current = 6;
                return;
            }
            case 94: {
                this.current = 4;
                return;
            }
            case 124: {
                this.current = 11;
                return;
            }
            case 35: {
                this.current = 12;
                return;
            }
            case 40: {
                this.current = 7;
                return;
            }
            case 41: {
                this.current = 8;
                return;
            }
            case 123: {
                this.current = 13;
                return;
            }
            case 125: {
                this.current = 14;
                return;
            }
        }
        this.current = 0;
        this.image = "" + new Character((char)tk);
    }

    @Override
    public int lineNumber() {
        return this.tokenizer.lineno();
    }

    @Override
    public Object label() {
        return this.image;
    }

    @Override
    public int value() {
        return this.value;
    }

    @Override
    public int current() {
        return this.current;
    }
}

