/*
 * Decompiled with CFR 0.152.
 */
package rationals.expr;

import rationals.algebra.SemiRing;
import rationals.expr.Letter;
import rationals.expr.Plus;
import rationals.expr.Product;

public abstract class RationalExpr
implements SemiRing {
    public static final RationalExpr zero = new RationalExpr(){

        @Override
        public SemiRing mult(SemiRing s1) {
            return zero;
        }

        @Override
        public SemiRing plus(SemiRing s1) {
            return s1;
        }

        public boolean equals(Object o) {
            return this == o;
        }

        public int hashcode() {
            return -1;
        }

        public String toString() {
            return "0";
        }
    };
    public static final RationalExpr one = Letter.epsilon;

    @Override
    public final SemiRing one() {
        return one;
    }

    @Override
    public final SemiRing zero() {
        return zero;
    }

    @Override
    public SemiRing mult(SemiRing s2) {
        if (s2 == zero) {
            return zero;
        }
        if (s2 == Letter.epsilon) {
            return this;
        }
        RationalExpr re = (RationalExpr)s2;
        return new Product(this, re);
    }

    @Override
    public SemiRing plus(SemiRing s2) {
        if (s2 == zero) {
            return this;
        }
        return new Plus(this, (RationalExpr)s2);
    }
}

