/*
 * Decompiled with CFR 0.152.
 */
package rationals.transformations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import rationals.Automaton;
import rationals.State;
import rationals.Transition;

public class TransformationsToolBox {
    public static boolean containsATerminalState(Set s) {
        Iterator i = s.iterator();
        while (i.hasNext()) {
            try {
                State e = (State)i.next();
                if (!e.isTerminal()) continue;
                return true;
            }
            catch (ClassCastException classCastException) {
            }
        }
        return false;
    }

    public static boolean containsAnInitialState(Set s) {
        Iterator i = s.iterator();
        while (i.hasNext()) {
            try {
                State e = (State)i.next();
                if (!e.isInitial()) continue;
                return true;
            }
            catch (ClassCastException classCastException) {
            }
        }
        return false;
    }

    public static Set<State> epsilonClosure(Set<State> s, Automaton a) {
        Set<State> exp = a.getStateFactory().stateSet();
        exp.addAll(s);
        Set<State> view = a.getStateFactory().stateSet();
        Set<State> arr = a.getStateFactory().stateSet();
        arr.addAll(s);
        do {
            Set<State> ns = a.getStateFactory().stateSet();
            ns.addAll(exp);
            for (State st : ns) {
                for (Transition tr : a.delta(st)) {
                    if (tr.label() != null || view.contains(tr.end()) || tr.end().equals(st)) continue;
                    exp.add(tr.end());
                    arr.add(tr.end());
                }
                exp.remove(st);
                view.add(st);
            }
        } while (!exp.isEmpty());
        return arr;
    }

    public static Map mapAlphabet(Set ts, Automaton a) {
        HashMap<Object, Set<State>> am = new HashMap<Object, Set<State>>();
        ArrayList tas = new ArrayList(ts);
        while (!tas.isEmpty()) {
            Transition tr = (Transition)tas.remove(0);
            Object l = tr.label();
            if (l == null) continue;
            Set<State> as = (Set<State>)am.get(l);
            if (as == null) {
                as = a.getStateFactory().stateSet();
                am.put(l, as);
            }
            as.add(tr.end());
        }
        return am;
    }
}

