/*
 * Decompiled with CFR 0.152.
 */
package com.herohan.uvcapp;

import android.content.Context;
import android.hardware.usb.UsbDevice;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import com.herohan.uvcapp.CameraInternal;
import com.herohan.uvcapp.CameraPreviewConfig;
import com.herohan.uvcapp.ICameraConnection;
import com.herohan.uvcapp.ICameraHelper;
import com.herohan.uvcapp.ICameraInternal;
import com.herohan.uvcapp.ImageCapture;
import com.herohan.uvcapp.ImageCaptureConfig;
import com.herohan.uvcapp.VideoCapture;
import com.herohan.uvcapp.VideoCaptureConfig;
import com.serenegiant.usb.DeviceFilter;
import com.serenegiant.usb.Format;
import com.serenegiant.usb.IButtonCallback;
import com.serenegiant.usb.IFrameCallback;
import com.serenegiant.usb.Size;
import com.serenegiant.usb.USBMonitor;
import com.serenegiant.usb.UVCControl;
import com.serenegiant.usb.UVCParam;
import com.serenegiant.utils.UVCUtils;
import com.serenegiant.uvccamera.R;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;

class CameraConnectionService {
    private static final boolean DEBUG = false;
    private static final String TAG = CameraConnectionService.class.getSimpleName();
    private static volatile CameraConnectionService mInstance;

    CameraConnectionService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CameraConnectionService getInstance() {
        if (mInstance != null) return mInstance;
        Class<CameraConnectionService> clazz = CameraConnectionService.class;
        synchronized (CameraConnectionService.class) {
            if (mInstance != null) return mInstance;
            mInstance = new CameraConnectionService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public ICameraConnection newConnection() {
        return new CameraConnection();
    }

    private final class CameraConnection
    implements ICameraConnection {
        private final String LOG_PREFIX = "CameraConnection#";
        private final Object mConnectionSync = new Object();
        private final HashMap<String, CameraInternal> mCameras = new HashMap();
        private USBMonitor mUSBMonitor;
        private HandlerThread mListenerHandlerThread = new HandlerThread("CameraConnection#" + this.hashCode());
        private Handler mListenerHandler;
        private WeakReference<ICameraHelper.StateCallback> mWeakStateCallback;

        CameraConnection() {
            this.mListenerHandlerThread.start();
            this.mListenerHandler = new Handler(this.mListenerHandlerThread.getLooper());
            this.mUSBMonitor = new USBMonitor((Context)UVCUtils.getApplication(), new MyOnDeviceConnectListener(), this.mListenerHandler);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CameraInternal addCamera(UsbDevice device, USBMonitor.UsbControlBlock ctrlBlock) {
            CameraInternal cameraInternal;
            String key = this.getCameraKey(device);
            Object object = this.mConnectionSync;
            synchronized (object) {
                cameraInternal = this.mCameras.get(key);
                if (cameraInternal == null) {
                    cameraInternal = new CameraInternal((Context)UVCUtils.getApplication(), ctrlBlock, device.getVendorId(), device.getProductId());
                    this.mCameras.put(key, cameraInternal);
                }
                this.mConnectionSync.notifyAll();
            }
            this.checkExistCamera();
            return cameraInternal;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeCamera(UsbDevice device) {
            String key = this.getCameraKey(device);
            Object object = this.mConnectionSync;
            synchronized (object) {
                CameraInternal service = this.mCameras.get(key);
                if (service != null) {
                    service.release();
                }
                this.mCameras.remove(key);
                this.mConnectionSync.notifyAll();
            }
            this.checkExistCamera();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CameraInternal getCamera(UsbDevice device, boolean isBlocking) {
            Object object = this.mConnectionSync;
            synchronized (object) {
                CameraInternal cameraInternal = null;
                if (device == null) {
                    if (this.mCameras.size() > 0) {
                        cameraInternal = (CameraInternal)this.mCameras.values().toArray()[0];
                    }
                } else {
                    String cameraKey = this.getCameraKey(device);
                    cameraInternal = this.mCameras.get(cameraKey);
                    if (cameraInternal == null && isBlocking) {
                        Log.i((String)TAG, (String)"wait for service is ready");
                        try {
                            this.mConnectionSync.wait();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    cameraInternal = this.mCameras.get(cameraKey);
                }
                return cameraInternal;
            }
        }

        private CameraInternal getCamera(UsbDevice device) {
            return this.getCamera(device, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean checkExistCamera() {
            Object object = this.mConnectionSync;
            synchronized (object) {
                int n = this.mCameras.size();
                return n == 0;
            }
        }

        private String getCameraKey(UsbDevice device) {
            return USBMonitor.getDeviceKey(device);
        }

        @Override
        public void register(ICameraHelper.StateCallback callback) {
            this.mWeakStateCallback = new WeakReference<ICameraHelper.StateCallback>(callback);
            if (this.mUSBMonitor != null) {
                List<DeviceFilter> filters = DeviceFilter.getDeviceFilters((Context)UVCUtils.getApplication(), R.xml.device_filter);
                this.mUSBMonitor.setDeviceFilter(filters);
                this.mUSBMonitor.register();
            }
        }

        @Override
        public void unregister(ICameraHelper.StateCallback callback) {
            if (this.mUSBMonitor != null) {
                this.mUSBMonitor.unregister();
                this.mUSBMonitor = null;
            }
            this.mWeakStateCallback.clear();
        }

        @Override
        public List<UsbDevice> getDeviceList() {
            return this.mUSBMonitor.getDeviceList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void selectDevice(UsbDevice device) {
            String cameraKey = this.getCameraKey(device);
            CameraInternal cameraInternal = null;
            Object object = this.mConnectionSync;
            synchronized (object) {
                Log.i((String)TAG, (String)"request permission");
                this.mUSBMonitor.requestPermission(device);
                cameraInternal = this.mCameras.get(cameraKey);
                if (cameraInternal == null) {
                    Log.i((String)TAG, (String)"wait for getting permission");
                    try {
                        this.mConnectionSync.wait();
                    }
                    catch (Exception e) {
                        Log.e((String)TAG, (String)"selectDevice:", (Throwable)e);
                    }
                    Log.i((String)TAG, (String)"check CameraInternal again");
                    cameraInternal = this.mCameras.get(cameraKey);
                    if (cameraInternal == null) {
                        throw new RuntimeException("failed to open USB device(has no permission)");
                    }
                }
            }
            Log.i((String)TAG, (String)("success to get service:serviceId=" + cameraKey));
        }

        @Override
        public List<Format> getSupportedFormatList(UsbDevice device) {
            CameraInternal cameraInternal = this.getCamera(device);
            if (cameraInternal != null) {
                return cameraInternal.getSupportedFormatList();
            }
            return null;
        }

        @Override
        public List<Size> getSupportedSizeList(UsbDevice device) {
            CameraInternal cameraInternal = this.getCamera(device);
            if (cameraInternal != null) {
                return cameraInternal.getSupportedSizeList();
            }
            return null;
        }

        @Override
        public Size getPreviewSize(UsbDevice device) {
            CameraInternal cameraInternal = this.getCamera(device);
            if (cameraInternal != null) {
                return cameraInternal.getPreviewSize();
            }
            return null;
        }

        @Override
        public void setPreviewSize(UsbDevice device, Size size) {
            CameraInternal cameraInternal = this.getCamera(device);
            if (cameraInternal == null) {
                throw new IllegalArgumentException("invalid device");
            }
            cameraInternal.setPreviewSize(size);
        }

        @Override
        public void addSurface(UsbDevice device, Object surface, boolean isRecordable) {
            CameraInternal cameraInternal = this.getCamera(device, false);
            if (cameraInternal != null) {
                cameraInternal.addSurface(surface, isRecordable);
            }
        }

        @Override
        public void removeSurface(UsbDevice device, Object surface) {
            CameraInternal cameraInternal = this.getCamera(device, false);
            if (cameraInternal != null) {
                cameraInternal.removeSurface(surface);
            }
        }

        @Override
        public void setButtonCallback(UsbDevice device, IButtonCallback callback) {
            CameraInternal cameraInternal = this.getCamera(device);
            if (cameraInternal != null) {
                cameraInternal.setButtonCallback(callback);
            }
        }

        @Override
        public void setFrameCallback(UsbDevice device, IFrameCallback callback, int pixelFormat) {
            CameraInternal cameraInternal = this.getCamera(device);
            if (cameraInternal != null) {
                cameraInternal.setFrameCallback(callback, pixelFormat);
            }
        }

        @Override
        public void openCamera(UsbDevice device, UVCParam param, CameraPreviewConfig previewConfig, ImageCaptureConfig imageCaptureConfig, VideoCaptureConfig videoCaptureConfig) {
            CameraInternal cameraInternal = this.getCamera(device);
            if (cameraInternal == null) {
                throw new IllegalArgumentException("invalid device");
            }
            cameraInternal.openCamera(param, previewConfig, imageCaptureConfig, videoCaptureConfig);
        }

        @Override
        public void closeCamera(UsbDevice device) {
            CameraInternal cameraInternal = this.getCamera(device);
            if (cameraInternal == null) {
                throw new IllegalArgumentException("invalid device");
            }
            cameraInternal.closeCamera();
        }

        @Override
        public void startPreview(UsbDevice device) {
            CameraInternal cameraInternal = this.getCamera(device);
            if (cameraInternal == null) {
                throw new IllegalArgumentException("invalid device");
            }
            cameraInternal.startPreview();
        }

        @Override
        public void stopPreview(UsbDevice device) {
            CameraInternal cameraInternal = this.getCamera(device);
            if (cameraInternal == null) {
                throw new IllegalArgumentException("invalid device");
            }
            cameraInternal.stopPreview();
        }

        @Override
        public UVCControl getUVCControl(UsbDevice device) {
            CameraInternal cameraInternal = this.getCamera(device);
            if (cameraInternal != null) {
                return cameraInternal.getUVCControl();
            }
            return null;
        }

        @Override
        public void takePicture(UsbDevice device, ImageCapture.OutputFileOptions options, ImageCapture.OnImageCaptureCallback callback) {
            CameraInternal cameraInternal = this.getCamera(device);
            if (cameraInternal != null) {
                cameraInternal.takePicture(options, callback);
            }
        }

        @Override
        public boolean isRecording(UsbDevice device) {
            CameraInternal cameraInternal = this.getCamera(device, false);
            return cameraInternal != null && cameraInternal.isRecording();
        }

        @Override
        public void startRecording(UsbDevice device, VideoCapture.OutputFileOptions options, VideoCapture.OnVideoCaptureCallback callback) {
            CameraInternal cameraInternal = this.getCamera(device);
            if (cameraInternal != null) {
                cameraInternal.startRecording(options, callback);
            }
        }

        @Override
        public void stopRecording(UsbDevice device) {
            CameraInternal cameraInternal = this.getCamera(device);
            if (cameraInternal != null) {
                cameraInternal.stopRecording();
            }
        }

        @Override
        public boolean isCameraOpened(UsbDevice device) {
            CameraInternal cameraInternal = this.getCamera(device, false);
            return cameraInternal != null && cameraInternal.isCameraOpened();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void releaseCamera(UsbDevice device) {
            String cameraKey = this.getCameraKey(device);
            Object object = this.mConnectionSync;
            synchronized (object) {
                CameraInternal cameraInternal = this.mCameras.get(cameraKey);
                if (cameraInternal != null) {
                    cameraInternal.release();
                }
                this.mCameras.remove(cameraKey);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void releaseAllCamera() {
            Object object = this.mConnectionSync;
            synchronized (object) {
                for (CameraInternal cameraInternal : this.mCameras.values()) {
                    if (cameraInternal == null) continue;
                    cameraInternal.release();
                }
                this.mCameras.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setPreviewConfig(UsbDevice device, CameraPreviewConfig config) {
            String cameraKey = this.getCameraKey(device);
            Object object = this.mConnectionSync;
            synchronized (object) {
                CameraInternal cameraInternal = this.mCameras.get(cameraKey);
                if (cameraInternal != null) {
                    cameraInternal.setPreviewConfig(config);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setImageCaptureConfig(UsbDevice device, ImageCaptureConfig config) {
            String cameraKey = this.getCameraKey(device);
            Object object = this.mConnectionSync;
            synchronized (object) {
                CameraInternal cameraInternal = this.mCameras.get(cameraKey);
                if (cameraInternal != null) {
                    cameraInternal.setImageCaptureConfig(config);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setVideoCaptureConfig(UsbDevice device, VideoCaptureConfig config) {
            String cameraKey = this.getCameraKey(device);
            Object object = this.mConnectionSync;
            synchronized (object) {
                CameraInternal cameraInternal = this.mCameras.get(cameraKey);
                if (cameraInternal != null) {
                    cameraInternal.setVideoCaptureConfig(config);
                }
            }
        }

        @Override
        public void release() {
            if (this.mUSBMonitor != null) {
                this.mUSBMonitor.destroy();
                this.mUSBMonitor = null;
            }
            this.mListenerHandlerThread.quitSafely();
            this.mWeakStateCallback.clear();
        }

        private class MyOnDeviceConnectListener
        implements USBMonitor.OnDeviceConnectListener {
            private MyOnDeviceConnectListener() {
            }

            @Override
            public void onAttach(UsbDevice device) {
                if (CameraConnection.this.mWeakStateCallback.get() != null) {
                    try {
                        ((ICameraHelper.StateCallback)CameraConnection.this.mWeakStateCallback.get()).onAttach(device);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }

            @Override
            public void onDeviceOpen(final UsbDevice device, USBMonitor.UsbControlBlock ctrlBlock, boolean createNew) {
                CameraInternal camera = CameraConnection.this.addCamera(device, ctrlBlock);
                camera.registerCallback(new ICameraInternal.StateCallback(){
                    boolean mIsCameraOpened = false;

                    @Override
                    public void onCameraOpen() {
                        if (!this.mIsCameraOpened) {
                            if (CameraConnection.this.mWeakStateCallback.get() != null) {
                                try {
                                    ((ICameraHelper.StateCallback)CameraConnection.this.mWeakStateCallback.get()).onCameraOpen(device);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                            this.mIsCameraOpened = true;
                        }
                    }

                    @Override
                    public void onCameraClose() {
                        if (this.mIsCameraOpened) {
                            if (CameraConnection.this.mWeakStateCallback.get() != null) {
                                try {
                                    ((ICameraHelper.StateCallback)CameraConnection.this.mWeakStateCallback.get()).onCameraClose(device);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                            this.mIsCameraOpened = false;
                        }
                    }
                });
                if (CameraConnection.this.mWeakStateCallback.get() != null) {
                    try {
                        ((ICameraHelper.StateCallback)CameraConnection.this.mWeakStateCallback.get()).onDeviceOpen(device, createNew);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }

            @Override
            public void onDeviceClose(UsbDevice device, USBMonitor.UsbControlBlock ctrlBlock) {
                if (CameraConnection.this.mWeakStateCallback.get() != null) {
                    try {
                        ((ICameraHelper.StateCallback)CameraConnection.this.mWeakStateCallback.get()).onDeviceClose(device);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                CameraConnection.this.removeCamera(device);
            }

            @Override
            public void onDetach(UsbDevice device) {
                if (CameraConnection.this.mWeakStateCallback.get() != null) {
                    try {
                        ((ICameraHelper.StateCallback)CameraConnection.this.mWeakStateCallback.get()).onDetach(device);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                CameraConnection.this.removeCamera(device);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCancel(UsbDevice device) {
                if (CameraConnection.this.mWeakStateCallback.get() != null) {
                    try {
                        ((ICameraHelper.StateCallback)CameraConnection.this.mWeakStateCallback.get()).onCancel(device);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                Object object = CameraConnection.this.mConnectionSync;
                synchronized (object) {
                    CameraConnection.this.mConnectionSync.notifyAll();
                }
            }
        }
    }
}

