/*
 * Decompiled with CFR 0.152.
 */
package com.herohan.uvcapp;

import android.app.Application;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.usb.UsbDevice;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import com.herohan.uvcapp.CameraConnectionService;
import com.herohan.uvcapp.CameraPreviewConfig;
import com.herohan.uvcapp.ICameraConnection;
import com.herohan.uvcapp.ICameraHelper;
import com.herohan.uvcapp.ImageCapture;
import com.herohan.uvcapp.ImageCaptureConfig;
import com.herohan.uvcapp.VideoCapture;
import com.herohan.uvcapp.VideoCaptureConfig;
import com.serenegiant.usb.Format;
import com.serenegiant.usb.IButtonCallback;
import com.serenegiant.usb.IFrameCallback;
import com.serenegiant.usb.Size;
import com.serenegiant.usb.UVCControl;
import com.serenegiant.usb.UVCParam;
import com.serenegiant.utils.UVCUtils;
import java.lang.ref.WeakReference;
import java.util.List;

public class CameraHelper
implements ICameraHelper {
    private static final boolean DEBUG = false;
    private static final String TAG = CameraHelper.class.getSimpleName();
    protected final WeakReference<Context> mWeakContext;
    private HandlerThread mAsyncHandlerThread;
    private Handler mAsyncHandler;
    private Handler mMainHandler = new Handler(Looper.getMainLooper());
    protected ICameraConnection mService;
    protected ICameraHelper.StateCallback mCallbackWrapper;
    private UsbDevice mUsbDevice;
    private CameraPreviewConfig mCameraPreviewConfig = new CameraPreviewConfig();
    private ImageCaptureConfig mImageCaptureConfig = new ImageCaptureConfig();
    private VideoCaptureConfig mVideoCaptureConfig = new VideoCaptureConfig();

    public CameraHelper() {
        this.mWeakContext = new WeakReference<Application>(UVCUtils.getApplication());
        this.mAsyncHandlerThread = new HandlerThread(TAG);
        this.mAsyncHandlerThread.start();
        this.mAsyncHandler = new Handler(this.mAsyncHandlerThread.getLooper());
        this.mService = CameraConnectionService.getInstance().newConnection();
    }

    @Override
    public void setStateCallback(ICameraHelper.StateCallback callback) {
        if (callback != null) {
            this.mCallbackWrapper = new StateCallbackWrapper(callback);
            this.registerCallback();
        } else {
            this.unregisterCallback();
            this.mCallbackWrapper = null;
        }
    }

    @Override
    public List<UsbDevice> getDeviceList() {
        if (this.mService != null) {
            try {
                return this.mService.getDeviceList();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public void selectDevice(UsbDevice device) {
        this.mAsyncHandler.post(() -> {
            if (this.mService != null) {
                this.mUsbDevice = device;
                try {
                    this.mService.selectDevice(device);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public List<Format> getSupportedFormatList() {
        if (this.mService != null && this.mUsbDevice != null) {
            try {
                return this.mService.getSupportedFormatList(this.mUsbDevice);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public List<Size> getSupportedSizeList() {
        if (this.mService != null && this.mUsbDevice != null) {
            try {
                return this.mService.getSupportedSizeList(this.mUsbDevice);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Size getPreviewSize() {
        if (this.mService != null && this.mUsbDevice != null) {
            try {
                return this.mService.getPreviewSize(this.mUsbDevice);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public void setPreviewSize(Size size) {
        this.mAsyncHandler.post(() -> {
            if (this.mService != null && this.mUsbDevice != null) {
                try {
                    this.mService.setPreviewSize(this.mUsbDevice, size);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private Object fetchSurface(Object surface) {
        Object sur;
        if (surface instanceof SurfaceView) {
            SurfaceView surfaceView = (SurfaceView)surface;
            sur = surfaceView.getHolder().getSurface();
        } else if (surface instanceof SurfaceHolder) {
            SurfaceHolder holder = (SurfaceHolder)surface;
            sur = holder.getSurface();
        } else if (surface instanceof Surface || surface instanceof SurfaceTexture) {
            sur = surface;
        } else {
            throw new UnsupportedOperationException("addSurface() can only be called with an instance of Surface, SurfaceView, SurfaceTexture or SurfaceHolder at the moment.");
        }
        if (sur == null) {
            throw new UnsupportedOperationException("surface is null.");
        }
        return sur;
    }

    @Override
    public void addSurface(Object surface, boolean isRecordable) {
        this.mAsyncHandler.post(() -> {
            Object sur = this.fetchSurface(surface);
            if (sur != null && this.mService != null && this.mUsbDevice != null) {
                try {
                    this.mService.addSurface(this.mUsbDevice, sur, isRecordable);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public void removeSurface(Object surface) {
        this.mAsyncHandler.post(() -> {
            Object sur = this.fetchSurface(surface);
            if (sur != null && this.mService != null && this.mUsbDevice != null) {
                try {
                    this.mService.removeSurface(this.mUsbDevice, sur);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public void setButtonCallback(IButtonCallback callback) {
        this.mAsyncHandler.post(() -> {
            if (this.mService != null && this.mUsbDevice != null) {
                try {
                    this.mService.setButtonCallback(this.mUsbDevice, callback);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public void setFrameCallback(IFrameCallback callback, int pixelFormat) {
        this.mAsyncHandler.post(() -> {
            if (this.mService != null && this.mUsbDevice != null) {
                try {
                    this.mService.setFrameCallback(this.mUsbDevice, callback, pixelFormat);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public void openCamera() {
        this.openCamera(new UVCParam());
    }

    @Override
    public void openCamera(Size size) {
        this.openCamera(new UVCParam(size, 0));
    }

    @Override
    public void openCamera(UVCParam param) {
        this.mAsyncHandler.post(() -> {
            if (this.mService != null && this.mUsbDevice != null) {
                try {
                    if (!this.mService.isCameraOpened(this.mUsbDevice)) {
                        this.mService.openCamera(this.mUsbDevice, param, this.mCameraPreviewConfig, this.mImageCaptureConfig, this.mVideoCaptureConfig);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public void closeCamera() {
        this.mAsyncHandler.post(() -> {
            if (this.mService != null && this.mUsbDevice != null) {
                try {
                    if (this.mService.isCameraOpened(this.mUsbDevice)) {
                        this.mService.closeCamera(this.mUsbDevice);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public void startPreview() {
        this.mAsyncHandler.post(() -> {
            if (this.mService != null && this.mUsbDevice != null) {
                try {
                    this.mService.startPreview(this.mUsbDevice);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public void stopPreview() {
        this.mAsyncHandler.post(() -> {
            if (this.mService != null && this.mUsbDevice != null) {
                try {
                    this.mService.stopPreview(this.mUsbDevice);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public UVCControl getUVCControl() {
        if (this.mService != null && this.mUsbDevice != null) {
            try {
                return this.mService.getUVCControl(this.mUsbDevice);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public void takePicture(ImageCapture.OutputFileOptions options, ImageCapture.OnImageCaptureCallback callback) {
        this.mAsyncHandler.post(() -> {
            if (this.mService != null && this.mUsbDevice != null) {
                try {
                    this.mService.takePicture(this.mUsbDevice, options, callback);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public boolean isRecording() {
        if (this.mService != null && this.mUsbDevice != null) {
            try {
                return this.mService.isRecording(this.mUsbDevice);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public void startRecording(VideoCapture.OutputFileOptions options, VideoCapture.OnVideoCaptureCallback callback) {
        this.mAsyncHandler.post(() -> {
            if (this.mService != null && this.mUsbDevice != null) {
                try {
                    this.mService.startRecording(this.mUsbDevice, options, callback);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public void stopRecording() {
        this.mAsyncHandler.post(() -> {
            if (this.isRecording() && this.mService != null && this.mUsbDevice != null) {
                try {
                    this.mService.stopRecording(this.mUsbDevice);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public boolean isCameraOpened() {
        if (this.mService != null && this.mUsbDevice != null) {
            try {
                return this.mService.isCameraOpened(this.mUsbDevice);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public void release() {
        this.mAsyncHandler.post(() -> {
            if (this.mService != null) {
                try {
                    if (this.mUsbDevice != null) {
                        this.mService.releaseCamera(this.mUsbDevice);
                    }
                    this.mService.release();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.mCallbackWrapper = null;
                this.mService = null;
            }
            this.mUsbDevice = null;
            this.mAsyncHandlerThread.quitSafely();
        });
    }

    @Override
    public void releaseAll() {
        this.mAsyncHandler.post(() -> {
            if (this.mService != null) {
                try {
                    this.mService.releaseAllCamera();
                    this.mService.release();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.mCallbackWrapper = null;
                this.mService = null;
            }
            this.mUsbDevice = null;
            this.mAsyncHandlerThread.quitSafely();
        });
    }

    @Override
    public CameraPreviewConfig getPreviewConfig() {
        return this.mCameraPreviewConfig;
    }

    @Override
    public void setPreviewConfig(CameraPreviewConfig config) {
        this.mCameraPreviewConfig = config;
        this.mAsyncHandler.post(() -> {
            if (this.isCameraOpened() && this.mService != null && this.mUsbDevice != null) {
                try {
                    this.mService.setPreviewConfig(this.mUsbDevice, this.mCameraPreviewConfig);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public ImageCaptureConfig getImageCaptureConfig() {
        return this.mImageCaptureConfig;
    }

    @Override
    public void setImageCaptureConfig(ImageCaptureConfig config) {
        this.mImageCaptureConfig = config;
        this.mAsyncHandler.post(() -> {
            if (this.isCameraOpened() && this.mService != null && this.mUsbDevice != null) {
                try {
                    this.mService.setImageCaptureConfig(this.mUsbDevice, this.mImageCaptureConfig);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public VideoCaptureConfig getVideoCaptureConfig() {
        return this.mVideoCaptureConfig;
    }

    @Override
    public void setVideoCaptureConfig(VideoCaptureConfig config) {
        this.mVideoCaptureConfig = config;
        this.mAsyncHandler.post(() -> {
            if (this.isCameraOpened() && this.mService != null && this.mUsbDevice != null) {
                try {
                    this.mService.setVideoCaptureConfig(this.mUsbDevice, this.mVideoCaptureConfig);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public void registerCallback() {
        if (this.mService != null) {
            try {
                this.mService.register(this.mCallbackWrapper);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void unregisterCallback() {
        if (this.mService != null) {
            try {
                this.mService.unregister(this.mCallbackWrapper);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    final class StateCallbackWrapper
    implements ICameraHelper.StateCallback {
        private ICameraHelper.StateCallback mCallback;

        StateCallbackWrapper(ICameraHelper.StateCallback callback) {
            this.mCallback = callback;
        }

        @Override
        public void onAttach(UsbDevice device) {
            CameraHelper.this.mMainHandler.post(() -> this.mCallback.onAttach(device));
        }

        @Override
        public void onDeviceOpen(UsbDevice device, boolean isFirstOpen) {
            CameraHelper.this.mMainHandler.post(() -> this.mCallback.onDeviceOpen(device, isFirstOpen));
        }

        @Override
        public void onCameraOpen(UsbDevice device) {
            CameraHelper.this.mMainHandler.post(() -> this.mCallback.onCameraOpen(device));
        }

        @Override
        public void onCameraClose(UsbDevice device) {
            CameraHelper.this.mMainHandler.post(() -> this.mCallback.onCameraClose(device));
        }

        @Override
        public void onDeviceClose(UsbDevice device) {
            CameraHelper.this.mMainHandler.post(() -> this.mCallback.onDeviceClose(device));
        }

        @Override
        public void onDetach(UsbDevice device) {
            CameraHelper.this.mMainHandler.post(() -> this.mCallback.onDetach(device));
        }

        @Override
        public void onCancel(UsbDevice device) {
            CameraHelper.this.mMainHandler.post(() -> this.mCallback.onCancel(device));
        }
    }
}

