/*
 * Decompiled with CFR 0.152.
 */
package com.herohan.uvcapp;

import android.opengl.GLES20;
import android.opengl.Matrix;
import android.util.Log;
import android.view.Surface;
import androidx.annotation.Nullable;
import com.herohan.uvcapp.ICameraRendererHolder;
import com.herohan.uvcapp.ImageRawData;
import com.serenegiant.opengl.EGLBase;
import com.serenegiant.opengl.GLDrawer2D;
import com.serenegiant.opengl.renderer.RendererHolder;
import com.serenegiant.opengl.renderer.RendererHolderCallback;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

class CameraRendererHolder
extends RendererHolder
implements ICameraRendererHolder {
    private static final boolean DEBUG = false;
    private static final String TAG = CameraRendererHolder.class.getSimpleName();
    private CaptureHolder mCaptureHolder;

    public CameraRendererHolder(int width, int height, @Nullable RendererHolderCallback callback) {
        this(width, height, null, 2, 3, callback);
    }

    public CameraRendererHolder(int width, int height, EGLBase.IContext sharedContext, int flags, int maxClientVersion, @Nullable RendererHolderCallback callback) {
        super(width, height, sharedContext, flags, maxClientVersion, callback);
    }

    @Override
    protected void onPrimarySurfaceCreate(Surface surface) {
        super.onPrimarySurfaceCreate(surface);
        this.mRendererHandler.post(() -> {
            this.mCaptureHolder = new CaptureHolder();
        });
    }

    @Override
    protected void onPrimarySurfaceDestroy() {
        super.onPrimarySurfaceDestroy();
        this.mRendererHandler.post(() -> {
            if (this.mCaptureHolder != null) {
                this.mCaptureHolder.release();
                this.mCaptureHolder = null;
            }
        });
    }

    @Override
    public void captureImage(ICameraRendererHolder.OnImageCapturedCallback callback) {
        this.mRendererHandler.post(() -> {
            ImageRawData data = this.mCaptureHolder.captureImageRawData();
            callback.onCaptureSuccess(data);
        });
    }

    private class CaptureHolder {
        EGLBase mCaptureEglBase;
        EGLBase.IEglSurface mCaptureSurface;
        GLDrawer2D mCaptureDrawer;
        int mWidth = -1;
        int mHeight = -1;
        ByteBuffer mBuf = null;

        public CaptureHolder() {
            this.mCaptureEglBase = EGLBase.createFrom(CameraRendererHolder.this.getContext(), 3, false, 0, false);
            this.mCaptureSurface = this.mCaptureEglBase.createOffscreen(CameraRendererHolder.this.mVideoWidth, CameraRendererHolder.this.mVideoHeight);
            this.mCaptureDrawer = new GLDrawer2D(true);
        }

        public ImageRawData captureImageRawData() {
            ImageRawData data = null;
            if (this.mBuf == null || this.mWidth != CameraRendererHolder.this.mVideoWidth || this.mHeight != CameraRendererHolder.this.mVideoHeight) {
                this.mWidth = CameraRendererHolder.this.mVideoWidth;
                this.mHeight = CameraRendererHolder.this.mVideoHeight;
                this.mBuf = ByteBuffer.allocateDirect(this.mWidth * this.mHeight * 4);
                this.mBuf.order(ByteOrder.LITTLE_ENDIAN);
                if (this.mCaptureSurface != null) {
                    this.mCaptureSurface.release();
                    this.mCaptureSurface = null;
                }
                this.mCaptureSurface = this.mCaptureEglBase.createOffscreen(this.mWidth, this.mHeight);
            }
            if (this.mWidth > 0 && this.mHeight > 0) {
                float[] mvpMatrix = Arrays.copyOf(CameraRendererHolder.this.mMvpMatrix, 16);
                float[] mirrorMatrix = new float[16];
                Matrix.setIdentityM((float[])mirrorMatrix, (int)0);
                CameraRendererHolder.setMirrorMode(mirrorMatrix, 2);
                Matrix.multiplyMM((float[])mvpMatrix, (int)0, (float[])mirrorMatrix, (int)0, (float[])mvpMatrix, (int)0);
                this.mCaptureDrawer.setMvpMatrix(mvpMatrix, 0);
                this.mCaptureSurface.makeCurrent();
                this.mCaptureDrawer.draw(CameraRendererHolder.this.mTexId, CameraRendererHolder.this.mTexMatrix, 0);
                this.mCaptureSurface.swap();
                this.mBuf.clear();
                GLES20.glReadPixels((int)0, (int)0, (int)this.mWidth, (int)this.mHeight, (int)6408, (int)5121, (Buffer)this.mBuf);
                CameraRendererHolder.this.makeCurrent();
                byte[] bytes = new byte[this.mBuf.capacity()];
                this.mBuf.rewind();
                this.mBuf.get(bytes);
                data = new ImageRawData(bytes, this.mWidth, this.mHeight);
            } else {
                Log.w((String)TAG, (String)"#captureImageData:unexpectedly width/height is zero");
            }
            return data;
        }

        public void release() {
            if (this.mCaptureDrawer != null) {
                this.mCaptureDrawer.release();
                this.mCaptureDrawer = null;
            }
            if (this.mCaptureSurface != null) {
                this.mCaptureSurface.makeCurrent();
                this.mCaptureSurface.release();
                this.mCaptureSurface = null;
            }
            if (this.mCaptureEglBase != null) {
                this.mCaptureEglBase.release();
                this.mCaptureEglBase = null;
            }
        }
    }
}

