/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.api;

import com.heroku.api.Addon;
import com.heroku.api.AddonChange;
import com.heroku.api.App;
import com.heroku.api.Build;
import com.heroku.api.BuildpackInstallation;
import com.heroku.api.Collaborator;
import com.heroku.api.Dyno;
import com.heroku.api.Formation;
import com.heroku.api.Heroku;
import com.heroku.api.Key;
import com.heroku.api.Release;
import com.heroku.api.Slug;
import com.heroku.api.Source;
import com.heroku.api.StackInfo;
import com.heroku.api.User;
import com.heroku.api.connection.Connection;
import com.heroku.api.connection.ConnectionFactory;
import com.heroku.api.request.addon.AddonInstall;
import com.heroku.api.request.addon.AddonList;
import com.heroku.api.request.addon.AddonRemove;
import com.heroku.api.request.addon.AppAddonsList;
import com.heroku.api.request.app.AppCreate;
import com.heroku.api.request.app.AppDestroy;
import com.heroku.api.request.app.AppExists;
import com.heroku.api.request.app.AppInfo;
import com.heroku.api.request.app.AppList;
import com.heroku.api.request.app.AppRename;
import com.heroku.api.request.app.AppUpdate;
import com.heroku.api.request.buildpacks.BuildpackInstallationList;
import com.heroku.api.request.buildpacks.BuildpackInstallationUpdate;
import com.heroku.api.request.builds.BuildCreate;
import com.heroku.api.request.builds.BuildInfo;
import com.heroku.api.request.config.ConfigList;
import com.heroku.api.request.config.ConfigUpdate;
import com.heroku.api.request.dynos.DynoList;
import com.heroku.api.request.dynos.DynoRestart;
import com.heroku.api.request.dynos.DynoRestartAll;
import com.heroku.api.request.formation.FormationList;
import com.heroku.api.request.formation.FormationUpdate;
import com.heroku.api.request.key.KeyAdd;
import com.heroku.api.request.key.KeyList;
import com.heroku.api.request.key.KeyRemove;
import com.heroku.api.request.log.Log;
import com.heroku.api.request.log.LogStreamResponse;
import com.heroku.api.request.releases.ReleaseInfo;
import com.heroku.api.request.releases.ReleaseList;
import com.heroku.api.request.releases.Rollback;
import com.heroku.api.request.sharing.CollabList;
import com.heroku.api.request.sharing.SharingAdd;
import com.heroku.api.request.sharing.SharingRemove;
import com.heroku.api.request.sharing.SharingTransfer;
import com.heroku.api.request.slugs.SlugCreate;
import com.heroku.api.request.slugs.SlugInfo;
import com.heroku.api.request.sources.SourceCreate;
import com.heroku.api.request.stack.StackList;
import com.heroku.api.request.user.UserInfo;
import com.heroku.api.util.Range;
import java.util.List;
import java.util.Map;

public class HerokuAPI {
    protected final Connection connection;
    protected final String apiKey;

    public HerokuAPI(String apiKey) {
        this(ConnectionFactory.get(), apiKey);
    }

    public HerokuAPI(Connection connection, String apiKey) {
        this.connection = connection;
        this.apiKey = apiKey;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public User getUserInfo() {
        return this.connection.execute(new UserInfo(), this.apiKey);
    }

    public void addKey(String sshKey) {
        this.connection.execute(new KeyAdd(sshKey), this.apiKey);
    }

    public void removeKey(String sshKey) {
        this.connection.execute(new KeyRemove(sshKey), this.apiKey);
    }

    public List<Key> listKeys() {
        return this.connection.execute(new KeyList(), this.apiKey);
    }

    public Range<App> listApps() {
        return this.connection.execute(new AppList(), this.apiKey);
    }

    public Range<App> listApps(String range) {
        return this.connection.execute(new AppList(range), this.apiKey);
    }

    public App getApp(String name) {
        return this.connection.execute(new AppInfo(name), this.apiKey);
    }

    public boolean appExists(String name) {
        return this.connection.execute(new AppExists(name), this.apiKey);
    }

    public boolean isAppNameAvailable(String name) {
        return !this.appExists(name);
    }

    public App createApp() {
        return this.connection.execute(new AppCreate(new App().on(Heroku.Stack.Cedar14)), this.apiKey);
    }

    public App createApp(App app) {
        return this.connection.execute(new AppCreate(app), this.apiKey);
    }

    public String renameApp(String appName, String newName) {
        return this.connection.execute(new AppRename(appName, newName), this.apiKey).getName();
    }

    public void destroyApp(String appName) {
        this.connection.execute(new AppDestroy(appName), this.apiKey);
    }

    public AddonChange addAddon(String appName, String addonName) {
        return this.connection.execute(new AddonInstall(appName, addonName), this.apiKey);
    }

    public AddonChange addAddon(String appName, String addonName, Map<String, String> addonConfig) {
        return this.connection.execute(new AddonInstall(appName, addonName, addonConfig), this.apiKey);
    }

    public List<Addon> listAllAddons() {
        return this.connection.execute(new AddonList(), this.apiKey);
    }

    public List<Addon> listAppAddons(String appName) {
        return this.connection.execute(new AppAddonsList(appName), this.apiKey);
    }

    public AddonChange removeAddon(String appName, String addonName) {
        return this.connection.execute(new AddonRemove(appName, addonName), this.apiKey);
    }

    public List<Release> listReleases(String appName) {
        return this.connection.execute(new ReleaseList(appName), this.apiKey);
    }

    public List<Release> listReleases(String appName, String range) {
        return this.connection.execute(new ReleaseList(appName, range), this.apiKey);
    }

    public Release rollback(String appName, String releaseUuid) {
        return this.connection.execute(new Rollback(appName, releaseUuid), this.apiKey);
    }

    public Release getReleaseInfo(String appName, String releaseName) {
        return this.connection.execute(new ReleaseInfo(appName, releaseName), this.apiKey);
    }

    public List<Collaborator> listCollaborators(String appName) {
        return this.connection.execute(new CollabList(appName), this.apiKey);
    }

    public void addCollaborator(String appName, String collaborator) {
        this.connection.execute(new SharingAdd(appName, collaborator), this.apiKey);
    }

    public void removeCollaborator(String appName, String collaborator) {
        this.connection.execute(new SharingRemove(appName, collaborator), this.apiKey);
    }

    public void updateConfig(String appName, Map<String, String> config) {
        this.connection.execute(new ConfigUpdate(appName, config), this.apiKey);
    }

    public Map<String, String> listConfig(String appName) {
        return this.connection.execute(new ConfigList(appName), this.apiKey);
    }

    public void transferApp(String appName, String to) {
        this.connection.execute(new SharingTransfer(appName, to), this.apiKey);
    }

    public LogStreamResponse getLogs(String appName) {
        return this.connection.execute(new Log(appName), this.apiKey);
    }

    public LogStreamResponse getLogs(String appName, Boolean tail) {
        return this.connection.execute(new Log(appName, tail), this.apiKey);
    }

    public LogStreamResponse getLogs(Log.LogRequestBuilder logRequest) {
        return this.connection.execute(new Log(logRequest), this.apiKey);
    }

    public List<StackInfo> listAppStacks() {
        return this.connection.execute(new StackList(), this.apiKey);
    }

    public boolean isMaintenanceModeEnabled(String appName) {
        App app = this.connection.execute(new AppInfo(appName), this.apiKey);
        return app.isMaintenance();
    }

    public void setMaintenanceMode(String appName, boolean enable) {
        this.connection.execute(new AppUpdate(appName, enable), this.apiKey);
    }

    public Slug createSlug(String appName, Map<String, String> processTypes) {
        return this.connection.execute(new SlugCreate(appName, processTypes), this.apiKey);
    }

    public Slug getSlugInfo(String appName, String slugId) {
        return this.connection.execute(new SlugInfo(appName, slugId), this.apiKey);
    }

    public Source createSource() {
        return this.connection.execute(new SourceCreate(), this.apiKey);
    }

    public Build createBuild(String appName, Build build) {
        return this.connection.execute(new BuildCreate(appName, build), this.apiKey);
    }

    public Build getBuildInfo(String appName, String buildId) {
        return this.connection.execute(new BuildInfo(appName, buildId), this.apiKey);
    }

    public Range<Dyno> listDynos(String appName) {
        return this.connection.execute(new DynoList(appName), this.apiKey);
    }

    public void restartDyno(String appName, String dynoId) {
        this.connection.execute(new DynoRestart(appName, dynoId), this.apiKey);
    }

    public void restartDynos(String appName) {
        this.connection.execute(new DynoRestartAll(appName), this.apiKey);
    }

    public Formation scale(String appName, String processType, int quantity) {
        return this.connection.execute(new FormationUpdate(appName, processType, quantity), this.apiKey);
    }

    public List<Formation> listFormation(String appName) {
        return this.connection.execute(new FormationList(appName), this.apiKey);
    }

    public List<BuildpackInstallation> listBuildpackInstallations(String appName) {
        return this.connection.execute(new BuildpackInstallationList(appName), this.apiKey);
    }

    public void updateBuildpackInstallations(String appName, List<String> buildpacks) {
        this.connection.execute(new BuildpackInstallationUpdate(appName, buildpacks), this.apiKey);
    }
}

