/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.api.parser;

import com.heroku.api.exception.ParseException;
import com.heroku.api.http.HttpUtil;
import com.heroku.api.parser.Parser;
import com.heroku.api.request.Request;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.ServiceLoader;

public class Json {
    public static String encode(Object object) {
        return Holder.parser.encode(object);
    }

    public static <T> T parse(byte[] data, Type type) {
        return Holder.parser.parse(data, type);
    }

    public static <T> T parse(byte[] data, Class<? extends Request<T>> classType) {
        Type[] types = Json.doResolveTypeArguments(classType, classType, Request.class);
        if (types == null || types.length == 0) {
            throw new ParseException("Request<T> was not found for " + classType);
        }
        Type type = types[0];
        try {
            return Holder.parser.parse(data, type);
        }
        catch (RuntimeException e) {
            String json = HttpUtil.getUTF8String(data);
            throw new ParseException("Failed to parse JSON:" + json, e);
        }
    }

    private static Type[] doResolveTypeArguments(Class ownerClass, Class classToIntrospect, Class genericIfc) {
        while (classToIntrospect != null) {
            if (genericIfc.isInterface()) {
                Type[] ifcs;
                for (Type ifc : ifcs = classToIntrospect.getGenericInterfaces()) {
                    Type[] result = Json.doResolveTypeArguments(ownerClass, ifc, genericIfc);
                    if (result == null) continue;
                    return result;
                }
            } else {
                Type[] result = Json.doResolveTypeArguments(ownerClass, classToIntrospect.getGenericSuperclass(), genericIfc);
                if (result != null) {
                    return result;
                }
            }
            classToIntrospect = classToIntrospect.getSuperclass();
        }
        return null;
    }

    private static Type[] doResolveTypeArguments(Class ownerClass, Type ifc, Class genericIfc) {
        if (ifc instanceof ParameterizedType) {
            ParameterizedType paramIfc = (ParameterizedType)ifc;
            Type rawType = paramIfc.getRawType();
            if (genericIfc.equals(rawType)) {
                return paramIfc.getActualTypeArguments();
            }
            if (genericIfc.isAssignableFrom((Class)rawType)) {
                return Json.doResolveTypeArguments(ownerClass, (Class)rawType, genericIfc);
            }
        } else if (ifc != null && genericIfc.isAssignableFrom((Class)ifc)) {
            return Json.doResolveTypeArguments(ownerClass, (Class)ifc, genericIfc);
        }
        return null;
    }

    static class Holder {
        static Parser parser;

        Holder() {
        }

        static {
            ServiceLoader<Parser> loader = ServiceLoader.load(Parser.class, Parser.class.getClassLoader());
            Iterator<Parser> iterator = loader.iterator();
            if (!iterator.hasNext()) {
                throw new IllegalStateException("Unable to load a JSONProvider, please make sure you have a com.heroku.api.json.JSONParser implementationon your classpath that can be discovered and loaded via java.util.ServiceLoader");
            }
            parser = iterator.next();
        }
    }
}

