/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.api.request.domain;

import com.heroku.api.Heroku;
import com.heroku.api.exception.RequestFailedException;
import com.heroku.api.http.Http;
import com.heroku.api.http.HttpUtil;
import com.heroku.api.request.Request;
import com.heroku.api.request.RequestConfig;
import com.heroku.api.response.Unit;
import java.util.Collections;
import java.util.Map;

public class DomainRemove
implements Request<Unit> {
    private final RequestConfig config;

    public DomainRemove(String appName, String domainName) {
        this(new RequestConfig().app(appName).with(Heroku.RequestKey.DeleteDomain, domainName));
    }

    public DomainRemove(RequestConfig config) {
        this.config = config;
    }

    @Override
    public Http.Method getHttpMethod() {
        return Http.Method.DELETE;
    }

    @Override
    public String getEndpoint() {
        return Heroku.Resource.Domain.format(this.config.getAppName(), this.config.get(Heroku.RequestKey.DeleteDomain));
    }

    @Override
    public boolean hasBody() {
        return false;
    }

    @Override
    public String getBody() {
        throw HttpUtil.noBody();
    }

    @Override
    public Map<String, Object> getBodyAsMap() {
        throw HttpUtil.noBody();
    }

    @Override
    public Http.Accept getResponseType() {
        return Http.Accept.JSON;
    }

    @Override
    public Map<String, String> getHeaders() {
        return Collections.emptyMap();
    }

    @Override
    public Unit getResponse(byte[] bytes, int status, Map<String, String> responseHeaders) {
        if (Http.Status.OK.equals(status)) {
            return Unit.unit;
        }
        throw new RequestFailedException("Unable to remove domain.", status, bytes);
    }
}

