/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.api.request.releases;

import com.heroku.api.Heroku;
import com.heroku.api.Release;
import com.heroku.api.exception.RequestFailedException;
import com.heroku.api.http.Http;
import com.heroku.api.http.HttpUtil;
import com.heroku.api.parser.Json;
import com.heroku.api.request.Request;
import com.heroku.api.request.RequestConfig;
import com.heroku.api.util.Range;
import java.util.HashMap;
import java.util.Map;

public class ReleaseList
implements Request<Range<Release>> {
    private Map<String, String> headers = new HashMap<String, String>();
    private final RequestConfig config;

    public ReleaseList(String appName) {
        this.config = new RequestConfig().app(appName);
    }

    public ReleaseList(String appName, String range) {
        this(appName);
        this.headers.put("Range", range);
    }

    @Override
    public Http.Method getHttpMethod() {
        return Http.Method.GET;
    }

    @Override
    public String getEndpoint() {
        return Heroku.Resource.Releases.format(this.config.getAppName());
    }

    @Override
    public boolean hasBody() {
        return false;
    }

    @Override
    public String getBody() {
        throw HttpUtil.noBody();
    }

    @Override
    public Map<String, Object> getBodyAsMap() {
        throw HttpUtil.noBody();
    }

    @Override
    public Http.Accept getResponseType() {
        return Http.Accept.JSON;
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public Range<Release> getResponse(byte[] bytes, int status, Map<String, String> responseHeaders) {
        if (status == Http.Status.OK.statusCode) {
            return (Range)Json.parse(bytes, this.getClass());
        }
        if (status == 206) {
            Range r = (Range)Json.parse(bytes, ReleaseList.class);
            r.setNextRange(responseHeaders.get("Next-Range"));
            return r;
        }
        throw new RequestFailedException("Unable to list releases.", status, bytes);
    }
}

