/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.api.request.sharing;

import com.heroku.api.Collaborator;
import com.heroku.api.Heroku;
import com.heroku.api.exception.RequestFailedException;
import com.heroku.api.http.Http;
import com.heroku.api.http.HttpUtil;
import com.heroku.api.parser.Json;
import com.heroku.api.request.Request;
import com.heroku.api.request.RequestConfig;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class CollabList
implements Request<List<Collaborator>> {
    private final RequestConfig config;

    public CollabList(String appName) {
        this.config = new RequestConfig().app(appName);
    }

    @Override
    public Http.Method getHttpMethod() {
        return Http.Method.GET;
    }

    @Override
    public String getEndpoint() {
        return Heroku.Resource.Collaborators.format(this.config.getAppName());
    }

    @Override
    public boolean hasBody() {
        return false;
    }

    @Override
    public String getBody() {
        throw HttpUtil.noBody();
    }

    @Override
    public Map<String, Object> getBodyAsMap() {
        throw HttpUtil.noBody();
    }

    @Override
    public Http.Accept getResponseType() {
        return Http.Accept.JSON;
    }

    @Override
    public Map<String, String> getHeaders() {
        return Collections.emptyMap();
    }

    @Override
    public List<Collaborator> getResponse(byte[] bytes, int status, Map<String, String> responseHeaders) {
        if (status == Http.Status.OK.statusCode) {
            return (List)Json.parse(bytes, this.getClass());
        }
        throw new RequestFailedException("List collaborators failed.", status, bytes);
    }
}

