/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.sdk;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;

public class BasicKeyStore {
    private String password;
    private KeyStore keystore;
    protected static final String DEFAULT_TYPE = "PKCS12";

    public BasicKeyStore(String key, String cert, String password) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        this.password = password;
        this.keystore = BasicKeyStore.createKeyStore(new StringReader(key), new StringReader(cert), password);
    }

    public BasicKeyStore(String cert, String password) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        this.password = password;
        this.keystore = BasicKeyStore.createTrustStore(new StringReader(cert));
    }

    public BasicKeyStore(String cert, String password, X509Certificate[] acceptedIssuers) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        this.password = password;
        this.keystore = BasicKeyStore.createTrustStore(new StringReader(cert), acceptedIssuers);
    }

    public String password() {
        return this.password;
    }

    public KeyStore keyStore() {
        return this.keystore;
    }

    public String type() {
        return DEFAULT_TYPE;
    }

    public InputStream toInputStream() throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        return new ByteArrayInputStream(this.toBytes());
    }

    public byte[] toBytes() throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.store(bos);
        bos.close();
        return bos.toByteArray();
    }

    public void store(OutputStream out) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        this.keystore.store(out, this.password.toCharArray());
    }

    public void store(Path path) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        Files.write(path, this.toBytes(), new OpenOption[0]);
    }

    public File storeTemp() throws IOException, CertificateException, NoSuchAlgorithmException, KeyStoreException {
        File temp = File.createTempFile("env-keystore", this.type().toLowerCase());
        this.store(temp.toPath());
        return temp;
    }

    public void asFile(Consumer<File> c) throws IOException, CertificateException, NoSuchAlgorithmException, KeyStoreException {
        File temp = this.storeTemp();
        c.accept(temp);
        Files.delete(temp.toPath());
    }

    protected static KeyStore createKeyStore(Reader keyReader, Reader certReader, String password) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        X509Certificate certificate;
        PrivateKey key = BasicKeyStore.getPrivateKeyFromPEM(keyReader);
        keyReader.close();
        PEMParser parser = new PEMParser(certReader);
        KeyStore ks = KeyStore.getInstance(DEFAULT_TYPE);
        ks.load(null);
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
        while ((certificate = BasicKeyStore.parseCert(parser)) != null) {
            certificates.add(certificate);
        }
        ks.setKeyEntry("alias", key, password.toCharArray(), certificates.toArray(new X509Certificate[0]));
        parser.close();
        return ks;
    }

    protected static PrivateKey getPrivateKeyFromPEM(Reader keyReader) throws IOException {
        PrivateKey key;
        JcaPEMKeyConverter jcaPEMKeyConverter = new JcaPEMKeyConverter();
        PEMParser pem = new PEMParser(keyReader);
        Object pemContent = pem.readObject();
        if (pemContent instanceof PEMKeyPair) {
            PEMKeyPair pemKeyPair = (PEMKeyPair)pemContent;
            KeyPair keyPair = jcaPEMKeyConverter.getKeyPair(pemKeyPair);
            key = keyPair.getPrivate();
        } else if (pemContent instanceof PrivateKeyInfo) {
            PrivateKeyInfo privateKeyInfo = (PrivateKeyInfo)pemContent;
            key = jcaPEMKeyConverter.getPrivateKey(privateKeyInfo);
        } else {
            throw new IllegalArgumentException("Unsupported private key format '" + pemContent.getClass().getSimpleName() + '\"');
        }
        pem.close();
        return key;
    }

    protected static KeyStore createTrustStore(Reader certReader) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        return BasicKeyStore.createTrustStore(certReader, new X509Certificate[0]);
    }

    protected static KeyStore createTrustStore(Reader certReader, X509Certificate[] acceptedIssuers) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        X509Certificate certificate;
        PEMParser parser = new PEMParser(certReader);
        KeyStore ks = KeyStore.getInstance(DEFAULT_TYPE);
        ks.load(null);
        int i = 0;
        for (X509Certificate certificate2 : acceptedIssuers) {
            ks.setCertificateEntry(String.format("alias%d", i), certificate2);
            ++i;
        }
        while ((certificate = BasicKeyStore.parseCert(parser)) != null) {
            ks.setCertificateEntry(String.format("alias%d", i), certificate);
            ++i;
        }
        parser.close();
        return ks;
    }

    protected static X509Certificate parseCert(PEMParser parser) throws IOException, CertificateException {
        X509CertificateHolder certHolder = (X509CertificateHolder)parser.readObject();
        if (certHolder == null) {
            return null;
        }
        return new JcaX509CertificateConverter().getCertificate(certHolder);
    }
}

