/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.sdk;

import com.heroku.sdk.BasicKeyStore;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.function.Consumer;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class EnvKeyStore {
    private BasicKeyStore basicKeyStore;

    public static EnvKeyStore create(String keyEnvVar, String certEnvVar, String passwordEnvVar) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        return new EnvKeyStore(System.getenv(keyEnvVar), System.getenv(certEnvVar), System.getenv(passwordEnvVar));
    }

    public static EnvKeyStore create(String trustEnvVar, String passwordEnvVar) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        return new EnvKeyStore(System.getenv(trustEnvVar), System.getenv(passwordEnvVar));
    }

    public static EnvKeyStore addToDefaultTrustStore(String trustEnvVar) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init((KeyStore)null);
        X509TrustManager defaultTm = null;
        for (TrustManager tm : tmf.getTrustManagers()) {
            if (!(tm instanceof X509TrustManager)) continue;
            defaultTm = (X509TrustManager)tm;
            break;
        }
        return new EnvKeyStore(System.getenv(trustEnvVar), new BigInteger(130, new SecureRandom()).toString(32), defaultTm == null ? new X509Certificate[]{} : defaultTm.getAcceptedIssuers());
    }

    public static EnvKeyStore createFromPEMStrings(String key, String cert, String password) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        return new EnvKeyStore(key, cert, password);
    }

    public static EnvKeyStore createFromPEMStrings(String trust, String password) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        return new EnvKeyStore(trust, password);
    }

    public static EnvKeyStore createWithRandomPassword(String keyEnvVar, String certEnvVar) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        return new EnvKeyStore(System.getenv(keyEnvVar), System.getenv(certEnvVar), new BigInteger(130, new SecureRandom()).toString(32));
    }

    public static EnvKeyStore createWithRandomPassword(String trustEnvVar) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        return new EnvKeyStore(System.getenv(trustEnvVar), new BigInteger(130, new SecureRandom()).toString(32));
    }

    EnvKeyStore(String key, String cert, String password) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        this.basicKeyStore = new BasicKeyStore(key, cert, password);
    }

    EnvKeyStore(String cert, String password) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        this.basicKeyStore = new BasicKeyStore(cert, password);
    }

    EnvKeyStore(String cert, String password, X509Certificate[] acceptedIssuers) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        this.basicKeyStore = new BasicKeyStore(cert, password, acceptedIssuers);
    }

    public String password() {
        return this.basicKeyStore.password();
    }

    public KeyStore keyStore() {
        return this.basicKeyStore.keyStore();
    }

    public String type() {
        return "PKCS12";
    }

    public InputStream toInputStream() throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        return this.basicKeyStore.toInputStream();
    }

    public byte[] toBytes() throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        return this.basicKeyStore.toBytes();
    }

    public void store(OutputStream out) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        this.basicKeyStore.store(out);
    }

    public void store(Path path) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        this.basicKeyStore.store(path);
    }

    public File storeTemp() throws IOException, CertificateException, NoSuchAlgorithmException, KeyStoreException {
        return this.basicKeyStore.storeTemp();
    }

    public void asFile(Consumer<File> c) throws IOException, CertificateException, NoSuchAlgorithmException, KeyStoreException {
        this.basicKeyStore.asFile(c);
    }
}

