/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.sdk.deploy;

import com.heroku.api.HerokuAPI;
import com.heroku.sdk.deploy.Deployer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ConfigVars {
    private Deployer deployer;
    private HerokuAPI api;

    public ConfigVars(Deployer deployer, String apiKey) {
        this.deployer = deployer;
        this.api = new HerokuAPI(apiKey);
    }

    public void merge(Map<String, String> configVars) throws Exception {
        Map<String, String> existingConfigVars = this.getConfigVars();
        this.deployer.logDebug("Heroku existing config variables: " + existingConfigVars.keySet());
        HashMap<String, String> newConfigVars = new HashMap<String, String>();
        for (String key : configVars.keySet()) {
            newConfigVars.putAll(this.addConfigVar(key, configVars.get(key), existingConfigVars));
        }
        this.setConfigVars(newConfigVars);
    }

    protected Map<String, String> getConfigVars() throws Exception {
        return this.api.listConfig(this.deployer.getName());
    }

    protected void setConfigVars(Map<String, String> configVars) throws IOException {
        if (!configVars.isEmpty()) {
            this.api.updateConfig(this.deployer.getName(), configVars);
        }
    }

    private Map<String, String> addConfigVar(String key, String value, Map<String, String> existingConfigVars) {
        return this.addConfigVar(key, value, existingConfigVars, true);
    }

    private Map<String, String> addConfigVar(String key, String value, Map<String, String> existingConfigVars, Boolean force) {
        HashMap<String, String> m = new HashMap<String, String>();
        if (!existingConfigVars.containsKey(key) || !value.equals(existingConfigVars.get(key)) && force.booleanValue()) {
            m.put(key, value);
        }
        return m;
    }
}

