/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.sdk.deploy;

import com.heroku.sdk.deploy.App;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WarApp
extends App {
    protected File warFile;
    protected File webappRunnerJar;

    public WarApp(String name) throws IOException {
        super(name);
    }

    public WarApp(String name, List<String> buildpacks) throws IOException {
        super(name, buildpacks);
    }

    public WarApp(String client, String name, File warFile, File webappRunnerJar, File rootDir, File targetDir, List<String> buildpacks) {
        super(client, name, rootDir, targetDir, buildpacks);
        this.warFile = warFile;
        this.webappRunnerJar = webappRunnerJar;
    }

    @Override
    public void deploy(List<File> includedFiles, Map<String, String> configVars, String jdkVersion, Map<String, String> userDefinedProcessTypes, String buildFilename) throws Exception {
        includedFiles.add(this.webappRunnerJar);
        includedFiles.add(this.warFile);
        super.deploy(includedFiles, configVars, jdkVersion, new HashMap<String, String>(), buildFilename);
    }

    @Override
    protected Map<String, String> defaultProcTypes() {
        HashMap<String, String> processTypes = new HashMap<String, String>();
        processTypes.put("web", "java $JAVA_OPTS -jar " + this.relativize(this.webappRunnerJar) + " $WEBAPP_RUNNER_OPTS --port $PORT " + this.relativize(this.warFile));
        return processTypes;
    }
}

