/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.sdk.deploy.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.FileUtils;

public class Tar {
    public static File create(String filename, String directory, File workingDir, File outputDir) throws IOException, ArchiveException, InterruptedException {
        return new Pack(workingDir, directory).apply(filename, outputDir);
    }

    public static void extract(File tarFile, File outputDir) throws IOException, InterruptedException, ArchiveException {
        new Unpack(tarFile, outputDir).apply();
    }

    public static class Unpack {
        private File tarFile;
        private File outputDir;

        public Unpack(File tarFile, File outputDir) {
            this.tarFile = tarFile;
            this.outputDir = outputDir;
        }

        private ArchiveInputStream extract(InputStream input) throws ArchiveException {
            return new ArchiveStreamFactory().createArchiveInputStream(input);
        }

        public void apply() throws IOException, ArchiveException {
            try (FileInputStream fis = new FileInputStream(this.tarFile);
                 GZIPInputStream gzs = new GZIPInputStream(fis);){
                ArchiveInputStream archiveInputStream = this.extract(new BufferedInputStream(gzs));
                ArchiveEntry entry = archiveInputStream.getNextEntry();
                while (entry != null) {
                    if (entry.isDirectory()) {
                        FileUtils.forceMkdir((File)new File(this.outputDir, entry.getName()));
                    } else {
                        File destPath = new File(this.outputDir, entry.getName());
                        IOUtils.copy((InputStream)archiveInputStream, (OutputStream)new FileOutputStream(destPath));
                        if (((TarArchiveEntry)entry).getMode() == 493) {
                            destPath.setExecutable(true);
                        }
                    }
                    entry = archiveInputStream.getNextEntry();
                }
            }
        }
    }

    public static class Pack {
        private File workingDir;
        private String directory;

        public Pack(File workingDir, String directory) {
            this.workingDir = workingDir;
            this.directory = directory;
        }

        private List<File> recursiveListFiles(File f) {
            ArrayList<File> allFiles = new ArrayList<File>();
            for (File subFile : f.listFiles()) {
                if (subFile.isDirectory()) {
                    allFiles.addAll(this.recursiveListFiles(subFile));
                }
                allFiles.add(subFile);
            }
            return allFiles;
        }

        private void addFilesToTar(ArchiveOutputStream tarBall, File dir) throws IOException {
            for (File file : this.recursiveListFiles(dir)) {
                TarArchiveEntry tarFile;
                if (file.isDirectory()) continue;
                Path path = FileSystems.getDefault().getPath(file.getAbsolutePath(), new String[0]);
                String pathInTar = this.relativize(file);
                if (Files.isSymbolicLink(path)) {
                    tarFile = new TarArchiveEntry(pathInTar, 50);
                    String symbolicLink = Files.readSymbolicLink(path).toString();
                    tarFile.setLinkName(symbolicLink);
                    tarBall.putArchiveEntry((ArchiveEntry)tarFile);
                    tarBall.closeArchiveEntry();
                    continue;
                }
                tarFile = new TarArchiveEntry(file, pathInTar);
                tarFile.setSize(file.length());
                if (Files.isExecutable(path)) {
                    tarFile.setMode(493);
                }
                tarBall.putArchiveEntry((ArchiveEntry)tarFile);
                IOUtils.copy((InputStream)new FileInputStream(file), (OutputStream)tarBall);
                tarBall.closeArchiveEntry();
            }
        }

        private void compress(File sourceFile, File targetFile) throws IOException {
            try (FileOutputStream fos = new FileOutputStream(targetFile);
                 GZIPOutputStream gzs = new GZIPOutputStream(fos);
                 FileInputStream fis = new FileInputStream(sourceFile);){
                IOUtils.copy((InputStream)fis, (OutputStream)gzs);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private File apply(String archiveFilename, File outputDir) throws ArchiveException, IOException {
            File archive = new File(outputDir, archiveFilename + ".tar");
            FileOutputStream tarOutput = new FileOutputStream(archive);
            tarBall.setLongFileMode(2);
            try (TarArchiveOutputStream tarBall = (TarArchiveOutputStream)new ArchiveStreamFactory().createArchiveOutputStream("tar", (OutputStream)tarOutput);){
                this.addFilesToTar((ArchiveOutputStream)tarBall, new File(this.workingDir, this.directory));
            }
            File outputFile = new File(outputDir, archiveFilename);
            this.compress(archive, outputFile);
            FileUtils.deleteQuietly((File)archive);
            return outputFile;
        }

        private String relativize(File path) {
            String relativePath = new File(this.workingDir, this.directory).toURI().relativize(path.toURI()).getPath();
            return this.directory + "/" + relativePath;
        }
    }
}

