/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.sdk.deploy;

import com.heroku.sdk.deploy.ConfigVars;
import com.heroku.sdk.deploy.Toolbelt;
import com.heroku.sdk.deploy.endpoints.Builds;
import com.heroku.sdk.deploy.utils.Logger;
import com.heroku.sdk.deploy.utils.RestClient;
import com.heroku.sdk.deploy.utils.Tar;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.io.FileUtils;
import org.apache.http.client.HttpResponseException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;

public class Deployer {
    protected String client;
    protected String name;
    protected File rootDir;
    protected File targetDir;
    protected String apiKey = null;
    protected Logger logger;
    protected List<String> buildpacks;

    public void logInfo(String message) {
        this.logger.logInfo(message);
    }

    public void logDebug(String message) {
        this.logger.logDebug(message);
    }

    public void logWarn(String message) {
        this.logger.logWarn(message);
    }

    public void logError(String message) {
        this.logger.logError(message);
    }

    public Deployer(String client, String name, File rootDir, File targetDir, List<String> buildpacks, Logger logger) {
        this.logger = logger;
        this.client = client;
        this.buildpacks = buildpacks;
        this.name = this.getHerokuProperties().getProperty("heroku.appName", name);
        try {
            if (this.name == null) {
                this.name = Toolbelt.getAppName(rootDir);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not find app name: " + e.getMessage(), e);
        }
        this.rootDir = rootDir;
        this.targetDir = targetDir;
        try {
            FileUtils.forceDelete((File)this.getAppDir());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.getHerokuDir().mkdir();
        this.getAppDir().mkdir();
    }

    public String getName() {
        return this.name;
    }

    protected void deploy(Map<String, String> configVars, String jdkVersion, String buildFilename) throws Exception {
        try {
            this.mergeConfigVars(configVars);
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() == 404) {
                this.logError("! Could not find app: " + this.name);
            }
            throw e;
        }
        this.vendorJdk(jdkVersion);
        this.createRelease(this.createBuild(buildFilename));
    }

    public void prepare(List<File> includedFiles, Map<String, String> processTypes) throws IOException {
        this.logInfo("-----> Packaging application...");
        this.logInfo("       - app: " + this.name);
        try {
            for (File file : includedFiles) {
                this.logInfo("       - including: " + this.relativize(file));
                this.copy(file, new File(this.getAppDir(), this.relativize(file)));
            }
            try {
                FileUtils.forceDelete((File)new File(this.getAppDir(), this.relativize(this.getHerokuDir())));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.addExtras(processTypes);
        }
        catch (IOException ioe) {
            throw new IOException("There was an error packaging the application for deployment.", ioe);
        }
    }

    protected void addExtras(Map<String, String> processTypes) throws IOException {
        this.addMetadata();
        this.addProcfile(processTypes);
        this.addJdkOverlay();
    }

    private void addProcfile(Map<String, String> processTypes) throws IOException {
        Map<String, String> allProcessTypes = this.getProcfile();
        allProcessTypes.putAll(processTypes);
        if (allProcessTypes.isEmpty()) {
            this.logWarn("No processTypes specified!");
        }
        String procfile = "";
        for (String key : allProcessTypes.keySet()) {
            procfile = procfile + key + ": " + allProcessTypes.get(key) + "\n";
        }
        this.logDebug("Procfile:\n===================\n" + procfile + "\n===================");
        Files.write(Paths.get(new File(this.getAppDir(), "Procfile").getPath(), new String[0]), procfile.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private void addJdkOverlay() throws IOException {
        File jdkOverlayDir = new File(this.getRootDir(), ".jdk-overlay");
        File toJdkOverlayDir = new File(this.getAppDir(), ".jdk-overlay");
        if (jdkOverlayDir.exists()) {
            this.logInfo("       - including JDK overlay");
            FileUtils.copyDirectory((File)jdkOverlayDir, (File)toJdkOverlayDir);
        }
    }

    protected void copy(File file, File copyTarget) throws IOException {
        if (file.isDirectory()) {
            Files.walkFileTree(file.toPath(), new CopyFileVisitor(copyTarget.toPath()));
        } else {
            Files.createDirectories(copyTarget.getParentFile().toPath(), new FileAttribute[0]);
            Deployer.copy(file.toPath(), copyTarget.toPath());
        }
    }

    protected void mergeConfigVars(Map<String, String> configVars) throws Exception {
        new ConfigVars(this, this.getApiKey()).merge(configVars);
    }

    protected void createRelease(File tarFile) throws IOException, ArchiveException, InterruptedException {
        Builds builds = new Builds(this.name, this.client, this.parseCommit(), this.getApiKey(), this.buildpacks);
        builds.createSource();
        this.logDebug("Heroku Blob URL: " + builds.getBlobUrl());
        this.logInfo("-----> Uploading build...");
        builds.upload(tarFile, this.logger);
        this.logInfo("       - success");
        this.logInfo("-----> Deploying...");
        Map buildInfo = builds.build(new RestClient.OutputLogger(){

            @Override
            public void log(String line) {
                Deployer.this.logInfo("remote: " + line);
            }
        });
        if (!"succeeded".equals(buildInfo.get("status"))) {
            Thread.sleep(4000L);
            Map secondAttemptBuildInfo = builds.getBuildInfo((String)buildInfo.get("id"));
            if (!"succeeded".equals(secondAttemptBuildInfo.get("status"))) {
                this.logDebug("Failed Build ID: " + buildInfo.get("id"));
                this.logDebug("Failed Build Status: " + buildInfo.get("status"));
                this.logDebug("Failed Build UpdatedAt: " + buildInfo.get("updated_at"));
                throw new RuntimeException("The build failed");
            }
        }
        this.logInfo("-----> Done");
    }

    protected File createBuild(String tarFilename) throws InterruptedException, ArchiveException, IOException {
        this.logInfo("-----> Creating build...");
        try {
            FileUtils.forceDelete((File)new File(this.getHerokuDir(), tarFilename));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        File tarFile = Tar.create(tarFilename, "./", this.getAppDir(), this.getHerokuDir());
        Long size = tarFile.length() / 0x100000L;
        if (size == 0L) {
            size = 1L;
        }
        this.logInfo("       - file: " + this.relativize(tarFile));
        this.logInfo("       - size: " + size + "MB");
        return tarFile;
    }

    protected String getJdkVersion() {
        String defaultJdkVersion = "1.8";
        File sysPropsFile = new File(this.rootDir, "system.properties");
        if (sysPropsFile.exists()) {
            Properties props = new Properties();
            try {
                props.load(new FileInputStream(sysPropsFile));
                return props.getProperty("java.runtime.version", defaultJdkVersion);
            }
            catch (IOException e) {
                this.logDebug(e.getMessage());
            }
        }
        return defaultJdkVersion;
    }

    protected Properties getHerokuProperties() {
        Properties props = new Properties();
        File sysPropsFile = new File(this.rootDir, "heroku.properties");
        if (sysPropsFile.exists()) {
            try {
                props.load(new FileInputStream(sysPropsFile));
            }
            catch (IOException e) {
                this.logDebug(e.getMessage());
            }
        }
        return props;
    }

    protected Map<String, String> getProcfile() {
        HashMap<String, String> procTypes = new HashMap<String, String>();
        File procfile = new File(this.rootDir, "Procfile");
        if (procfile.exists()) {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(procfile));
                String line = reader.readLine();
                while (line != null) {
                    if (line.contains(":")) {
                        Integer colon = line.indexOf(":");
                        String key = line.substring(0, colon);
                        String value = line.substring(colon + 1);
                        procTypes.put(key.trim(), value.trim());
                    }
                    line = reader.readLine();
                }
            }
            catch (Exception e) {
                this.logDebug(e.getMessage());
            }
        }
        return procTypes;
    }

    protected void vendorJdk(String jdkVersion) throws IOException, InterruptedException, ArchiveException {
        String realJdkVersion;
        String string = realJdkVersion = jdkVersion == null ? this.getJdkVersion() : jdkVersion;
        if (realJdkVersion != null) {
            Files.write(Paths.get(new File(this.getAppDir(), "system.properties").getPath(), new String[0]), ("java.runtime.version=" + realJdkVersion).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
    }

    protected String relativize(File path) {
        if (path.isAbsolute() && !path.getPath().startsWith(this.rootDir.getPath())) {
            return path.getName();
        }
        return this.rootDir.toURI().relativize(path.toURI()).getPath();
    }

    protected String getApiKey() throws IOException {
        if (this.apiKey == null) {
            String key = System.getenv("HEROKU_API_KEY");
            if (null == key || key.isEmpty()) {
                try {
                    key = Toolbelt.getApiToken();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (key == null || key.isEmpty()) {
                throw new RuntimeException("Could not get API key! Please install the Heroku CLI and run `heroku login` or set the HEROKU_API_KEY environment variable.");
            }
            this.apiKey = key;
        }
        return this.apiKey;
    }

    protected File getAppDir() {
        return new File(this.getHerokuDir(), "app");
    }

    protected File getHerokuDir() {
        return new File(this.targetDir, "heroku");
    }

    protected File getRootDir() {
        return this.rootDir;
    }

    protected File getTargetDir() {
        return this.targetDir;
    }

    private static void copy(Path file, Path target) throws IOException {
        if (Files.isSymbolicLink(file)) {
            Files.createSymbolicLink(target, Files.readSymbolicLink(file), new FileAttribute[0]);
        } else {
            Files.copy(file, target, StandardCopyOption.COPY_ATTRIBUTES);
        }
    }

    protected String parseCommit() throws IOException {
        String providedCommit = System.getProperty("heroku.buildVersion");
        if (null == providedCommit) {
            FileRepositoryBuilder builder = new FileRepositoryBuilder();
            Repository repository = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)builder.setWorkTree(this.getRootDir())).readEnvironment()).findGitDir()).build();
            ObjectId head = repository.resolve("HEAD");
            return head == null ? null : head.name();
        }
        return providedCommit;
    }

    protected void addMetadata() throws IOException {
        String metadata = this.toPropertiesString();
        File metadataFile = new File(this.getAppDir(), ".heroku-deploy");
        if (!metadataFile.exists()) {
            Files.write(Paths.get(metadataFile.getPath(), new String[0]), metadata.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
    }

    protected String toPropertiesString() {
        return "client=" + this.client + "\n";
    }

    public static class CopyFileVisitor
    extends SimpleFileVisitor<Path> {
        private final Path targetPath;
        private Path sourcePath = null;

        public CopyFileVisitor(Path targetPath) {
            this.targetPath = targetPath;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            if (dir.equals(this.targetPath)) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            if (this.sourcePath == null) {
                this.sourcePath = dir;
            }
            Files.createDirectories(this.targetPath.resolve(this.sourcePath.relativize(dir)), new FileAttribute[0]);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Path target = this.targetPath.resolve(this.sourcePath.relativize(file));
            Deployer.copy(file, target);
            return FileVisitResult.CONTINUE;
        }
    }
}

