/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.sdk.deploy.lib.resolver;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.StoredConfig;

public class AppNameResolver {
    private static final List<Pattern> GIT_REMOTE_URL_APP_NAME_PATTERNS;

    public static Optional<String> resolve(Path projectDirectory, Supplier<Optional<String>> customResolver) throws IOException {
        Optional<String> herokuPropertiesAppName = AppNameResolver.resolveViaHerokuPropertiesFile(projectDirectory);
        if (herokuPropertiesAppName.isPresent()) {
            return herokuPropertiesAppName;
        }
        Optional<String> systemPropertiesAppName = AppNameResolver.resolveViaSystemProperty();
        if (systemPropertiesAppName.isPresent()) {
            return systemPropertiesAppName;
        }
        Optional<String> customResolverAppName = customResolver.get();
        if (customResolverAppName.isPresent()) {
            return customResolverAppName;
        }
        return AppNameResolver.resolveViaHerokuGitRemote(projectDirectory);
    }

    private static Optional<String> resolveViaHerokuGitRemote(Path rootDirectory) throws IOException {
        try {
            Git gitRepo = Git.open((File)rootDirectory.toFile());
            StoredConfig config = gitRepo.getRepository().getConfig();
            for (String remoteName : config.getSubsections("remote")) {
                String remoteUrl = config.getString("remote", remoteName, "url");
                for (Pattern gitRemoteUrlAppNamePattern : GIT_REMOTE_URL_APP_NAME_PATTERNS) {
                    Matcher matcher = gitRemoteUrlAppNamePattern.matcher(remoteUrl);
                    if (!matcher.matches()) continue;
                    return Optional.of(matcher.group(1));
                }
            }
        }
        catch (RepositoryNotFoundException e) {
            return Optional.empty();
        }
        return Optional.empty();
    }

    private static Optional<String> resolveViaHerokuPropertiesFile(Path rootDirectory) throws IOException {
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(rootDirectory.resolve("heroku.properties").toFile()));
        }
        catch (FileNotFoundException e) {
            return Optional.empty();
        }
        return Optional.ofNullable(properties.getProperty("heroku.appName"));
    }

    private static Optional<String> resolveViaSystemProperty() {
        return Optional.ofNullable(System.getProperty("heroku.appName"));
    }

    static {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        patterns.add(Pattern.compile("https://git\\.heroku\\.com/(.*?)\\.git"));
        patterns.add(Pattern.compile("git@heroku\\.com:(.*?)\\.git"));
        GIT_REMOTE_URL_APP_NAME_PATTERNS = Collections.unmodifiableList(patterns);
    }
}

