/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.sdk.deploy.lib.resolver;

import java.net.URI;
import java.util.Arrays;
import java.util.List;

public class WebappRunnerResolver {
    private static final List<String> knownLegacyVersions = Arrays.asList("9.0.27.1", "9.0.27.0", "9.0.24.1", "9.0.24.0", "9.0.22.0", "9.0.20.1", "9.0.20.0", "9.0.19.1", "9.0.19.0", "9.0.17.0", "9.0.16.0", "9.0.14.0", "9.0.13.0", "9.0.11.0", "9.0.8.1", "9.0.8.0", "8.5.47.2", "8.5.47.1", "8.5.47.0", "8.5.45.0", "8.5.43.1", "8.5.43.0", "8.5.41.1", "8.5.41.0", "8.5.40.1", "8.5.40.0", "8.5.39.0", "8.5.38.0", "8.5.37.1", "8.5.37.0", "8.5.35.0", "8.5.34.1", "8.5.34.0", "8.5.33.0", "8.5.32.1", "8.5.32.0", "8.5.31.1", "8.5.31.0", "8.5.30.0", "8.5.29.0", "8.5.28.0", "8.5.27.0", "8.5.24.0", "8.5.23.1", "8.5.23.0", "8.5.20.1", "8.5.20.0", "8.5.15.1", "8.5.15.0", "8.5.11.3", "8.5.11.2", "8.5.11.1", "8.5.11.0", "8.5.9.0", "8.5.5.2", "8.5.5.1", "8.5.5.0", "8.0.52.0", "8.0.51.0", "8.0.50.0", "8.0.47.0", "8.0.44.0", "8.0.39.0", "8.0.33.4", "8.0.33.3", "8.0.33.2", "8.0.33.1", "8.0.33.0", "8.0.30.2", "8.0.30.1", "8.0.30.0", "8.0.24.1", "8.0.24.0", "8.0.23.0", "8.0.18.0-M1", "7.0.91.0", "7.0.88.0", "7.0.86.0", "7.0.85.0", "7.0.84.0", "7.0.82.0", "7.0.57.2", "7.0.57.1", "7.0.40.2", "7.0.40.1", "7.0.40.0", "7.0.34.3", "7.0.34.2", "7.0.34.1", "7.0.34.0", "7.0.30.1", "7.0.29.3", "7.0.27.1", "7.0.22.3", "7.0.22.2", "7.0.22.1", "7.0.22");

    public static String getGroupIdForVersion(String version) {
        return WebappRunnerResolver.isLegacyVersion(version) ? "com.github.jsimone" : "com.heroku";
    }

    public static URI getUrlForVersion(String version) {
        String pattern = WebappRunnerResolver.isLegacyVersion(version) ? "https://repo1.maven.org/maven2/com/github/jsimone/webapp-runner/%s/webapp-runner-%s.jar" : "https://repo1.maven.org/maven2/com/heroku/webapp-runner/%s/webapp-runner-%s.jar";
        return URI.create(String.format(pattern, version, version));
    }

    private static boolean isLegacyVersion(String version) {
        return knownLegacyVersions.contains(version);
    }
}

